/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;

public class LoggingEventListener
extends AbstractMongoEventListener<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingEventListener.class);

    @Override
    public void onBeforeConvert(BeforeConvertEvent<Object> event) {
        LOGGER.info("onBeforeConvert: {}", event.getSource());
    }

    @Override
    public void onBeforeSave(BeforeSaveEvent<Object> event) {
        LOGGER.info("onBeforeSave: {}, {}", event.getSource(), (Object)event.getDBObject());
    }

    @Override
    public void onAfterSave(AfterSaveEvent<Object> event) {
        LOGGER.info("onAfterSave: {}, {}", event.getSource(), (Object)event.getDBObject());
    }

    @Override
    public void onAfterLoad(AfterLoadEvent<Object> event) {
        LOGGER.info("onAfterLoad: {}", (Object)event.getDBObject());
    }

    @Override
    public void onAfterConvert(AfterConvertEvent<Object> event) {
        LOGGER.info("onAfterConvert: {}, {}", (Object)event.getDBObject(), event.getSource());
    }

    @Override
    public void onAfterDelete(AfterDeleteEvent<Object> event) {
        LOGGER.info("onAfterDelete: {}", (Object)event.getDBObject());
    }

    @Override
    public void onBeforeDelete(BeforeDeleteEvent<Object> event) {
        LOGGER.info("onBeforeDelete: {}", (Object)event.getDBObject());
    }
}

