/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.WriteResult;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.DtoInstantiatingConverter;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

interface MongoQueryExecution {
    public Object execute(Query var1, Class<?> var2, String var3);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ResultProcessor processor;
        @NonNull
        private final MongoOperations operations;
        @NonNull
        private final EntityInstantiators instantiators;

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.operations.getConverter().getMappingContext(), this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }

        @ConstructorProperties(value={"processor", "operations", "instantiators"})
        public ResultProcessingConverter(@NonNull ResultProcessor processor, @NonNull MongoOperations operations, @NonNull EntityInstantiators instantiators) {
            if (processor == null) {
                throw new NullPointerException("processor");
            }
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (instantiators == null) {
                throw new NullPointerException("instantiators");
            }
            this.processor = processor;
            this.operations = operations;
            this.instantiators = instantiators;
        }
    }

    public static final class ResultProcessingExecution
    implements MongoQueryExecution {
        @NonNull
        private final MongoQueryExecution delegate;
        @NonNull
        private final Converter<Object, Object> converter;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.converter.convert(this.delegate.execute(query, type, collection));
        }

        @ConstructorProperties(value={"delegate", "converter"})
        public ResultProcessingExecution(@NonNull MongoQueryExecution delegate, @NonNull Converter<Object, Object> converter) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            if (converter == null) {
                throw new NullPointerException("converter");
            }
            this.delegate = delegate;
            this.converter = converter;
        }
    }

    public static final class StreamExecution
    implements MongoQueryExecution {
        @NonNull
        private final MongoOperations operations;
        @NonNull
        private final Converter<Object, Object> resultProcessing;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return StreamUtils.createStreamFromIterator(this.operations.stream(query, type)).map(new Function<Object, Object>(){

                @Override
                public Object apply(Object t) {
                    return StreamExecution.this.resultProcessing.convert(t);
                }
            });
        }

        @ConstructorProperties(value={"operations", "resultProcessing"})
        public StreamExecution(@NonNull MongoOperations operations, @NonNull Converter<Object, Object> resultProcessing) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (resultProcessing == null) {
                throw new NullPointerException("resultProcessing");
            }
            this.operations = operations;
            this.resultProcessing = resultProcessing;
        }
    }

    public static final class DeleteExecution
    implements MongoQueryExecution {
        private final MongoOperations operations;
        private final MongoQueryMethod method;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            if (this.method.isCollectionQuery()) {
                return this.operations.findAllAndRemove(query, type, collection);
            }
            WriteResult writeResult = this.operations.remove(query, type, collection);
            return writeResult != null ? (long)writeResult.getN() : 0L;
        }

        @ConstructorProperties(value={"operations", "method"})
        public DeleteExecution(MongoOperations operations, MongoQueryMethod method) {
            this.operations = operations;
            this.method = method;
        }
    }

    public static final class PagingGeoNearExecution
    extends GeoNearExecution {
        private final MongoOperations operations;
        private final MongoParameterAccessor accessor;
        private final AbstractMongoQuery mongoQuery;

        public PagingGeoNearExecution(MongoOperations operations, MongoParameterAccessor accessor, TypeInformation<?> returnType, AbstractMongoQuery query) {
            super(operations, accessor, returnType);
            this.accessor = accessor;
            this.operations = operations;
            this.mongoQuery = query;
        }

        @Override
        public Object execute(Query query, Class<?> type, final String collection) {
            GeoResults<Object> geoResults = this.doExecuteQuery(query, type, collection);
            Page page = PageableExecutionUtils.getPage((List)geoResults.getContent(), (Pageable)this.accessor.getPageable(), (PageableExecutionUtils.TotalSupplier)new PageableExecutionUtils.TotalSupplier(){

                public long get() {
                    ConvertingParameterAccessor parameterAccessor = new ConvertingParameterAccessor(PagingGeoNearExecution.this.operations.getConverter(), PagingGeoNearExecution.this.accessor);
                    Query countQuery = PagingGeoNearExecution.this.mongoQuery.applyQueryMetaAttributesWhenPresent(PagingGeoNearExecution.this.mongoQuery.createCountQuery(parameterAccessor));
                    return PagingGeoNearExecution.this.operations.count(countQuery, collection);
                }
            });
            return new GeoPage(geoResults, this.accessor.getPageable(), page.getTotalElements());
        }
    }

    public static class GeoNearExecution
    implements MongoQueryExecution {
        private final MongoOperations operations;
        private final MongoParameterAccessor accessor;
        private final TypeInformation<?> returnType;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            GeoResults<Object> results = this.doExecuteQuery(query, type, collection);
            return this.isListOfGeoResult() ? results.getContent() : results;
        }

        protected GeoResults<Object> doExecuteQuery(Query query, Class<?> type, String collection) {
            Pageable pageable;
            Distance minDistance;
            Range<Distance> distances;
            Distance maxDistance;
            Point nearLocation = this.accessor.getGeoNearLocation();
            NearQuery nearQuery = NearQuery.near(nearLocation);
            if (query != null) {
                nearQuery.query(query);
            }
            if ((maxDistance = (Distance)(distances = this.accessor.getDistanceRange()).getUpperBound()) != null) {
                nearQuery.maxDistance(maxDistance).in(maxDistance.getMetric());
            }
            if ((minDistance = (Distance)distances.getLowerBound()) != null) {
                nearQuery.minDistance(minDistance).in(minDistance.getMetric());
            }
            if ((pageable = this.accessor.getPageable()) != null) {
                nearQuery.with(pageable);
            }
            return this.operations.geoNear(nearQuery, type, collection);
        }

        private boolean isListOfGeoResult() {
            if (!this.returnType.getType().equals(List.class)) {
                return false;
            }
            TypeInformation componentType = this.returnType.getComponentType();
            return componentType != null && GeoResult.class.equals((Object)componentType.getType());
        }

        @ConstructorProperties(value={"operations", "accessor", "returnType"})
        public GeoNearExecution(MongoOperations operations, MongoParameterAccessor accessor, TypeInformation<?> returnType) {
            this.operations = operations;
            this.accessor = accessor;
            this.returnType = returnType;
        }
    }

    public static final class SingleEntityExecution
    implements MongoQueryExecution {
        private final MongoOperations operations;
        private final boolean countProjection;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.countProjection ? Long.valueOf(this.operations.count(query, type, collection)) : this.operations.findOne(query, type, collection);
        }

        @ConstructorProperties(value={"operations", "countProjection"})
        public SingleEntityExecution(MongoOperations operations, boolean countProjection) {
            this.operations = operations;
            this.countProjection = countProjection;
        }
    }

    public static final class PagedExecution
    implements MongoQueryExecution {
        @NonNull
        private final MongoOperations operations;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(final Query query, final Class<?> type, final String collection) {
            final int overallLimit = query.getLimit();
            query.with(this.pageable);
            if (overallLimit != 0 && this.pageable.getOffset() + this.pageable.getPageSize() > overallLimit) {
                query.limit(overallLimit - this.pageable.getOffset());
            }
            return PageableExecutionUtils.getPage(this.operations.find(query, type, collection), (Pageable)this.pageable, (PageableExecutionUtils.TotalSupplier)new PageableExecutionUtils.TotalSupplier(){

                public long get() {
                    long count = PagedExecution.this.operations.count(query, type, collection);
                    return overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
                }
            });
        }

        @ConstructorProperties(value={"operations", "pageable"})
        public PagedExecution(@NonNull MongoOperations operations, @NonNull Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (pageable == null) {
                throw new NullPointerException("pageable");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }

    public static final class SlicedExecution
    implements MongoQueryExecution {
        @NonNull
        private final MongoOperations operations;
        @NonNull
        private final Pageable pageable;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            int pageSize = this.pageable.getPageSize();
            Query modifiedQuery = query.with(this.pageable).limit(pageSize + 1);
            List<?> result = this.operations.find(modifiedQuery, type, collection);
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }

        @ConstructorProperties(value={"operations", "pageable"})
        public SlicedExecution(@NonNull MongoOperations operations, @NonNull Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            if (pageable == null) {
                throw new NullPointerException("pageable");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }

    public static final class CollectionExecution
    implements MongoQueryExecution {
        @NonNull
        private final MongoOperations operations;
        private final Pageable pageable;

        @Override
        public Object execute(Query query, Class<?> type, String collection) {
            return this.operations.find(query.with(this.pageable), type, collection);
        }

        @ConstructorProperties(value={"operations", "pageable"})
        public CollectionExecution(@NonNull MongoOperations operations, Pageable pageable) {
            if (operations == null) {
                throw new NullPointerException("operations");
            }
            this.operations = operations;
            this.pageable = pageable;
        }
    }
}

