/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries;

import io.corbel.lib.queries.exception.QueryMatchingException;
import io.corbel.lib.queries.request.QueryLiteral;
import io.corbel.lib.queries.request.QueryOperator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ListQueryLiteral
extends QueryLiteral<List<QueryLiteral>> {
    public ListQueryLiteral() {
    }

    public ListQueryLiteral(List list) {
        super(list);
    }

    @Override
    protected boolean in(Object object) throws QueryMatchingException {
        for (QueryLiteral queryLiteral : (List)this.literal) {
            if (!queryLiteral.operate(QueryOperator.$EQ, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean all(Object object) throws QueryMatchingException {
        List objectList = (List)object;
        for (QueryLiteral queryLiteral : (List)this.literal) {
            Iterator iterator = objectList.iterator();
            boolean flag = false;
            while (iterator.hasNext() && !flag) {
                flag = queryLiteral.operate(QueryOperator.$EQ, iterator.next());
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean eq(Object object) throws QueryMatchingException {
        List objectList = (List)object;
        return objectList.size() == ((List)this.literal).size() && this.all(object);
    }

    @Override
    protected boolean ne(Object object) throws QueryMatchingException {
        List objectList = (List)object;
        return objectList.size() != ((List)this.literal).size() || !this.all(object);
    }

    public List<Object> getLiterals() {
        return ((List)this.literal).stream().map(QueryLiteral::getLiteral).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : ((List)this.literal).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListQueryLiteral other = (ListQueryLiteral)obj;
        return !(this.literal == null ? other.literal != null : !((List)this.literal).equals(other.literal));
    }

    public String toString() {
        return ((List)this.literal).stream().map(item -> item.toString()).collect(Collectors.joining(",", "[", "]"));
    }
}

