/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.builder;

import io.corbel.lib.queries.BooleanQueryLiteral;
import io.corbel.lib.queries.DateQueryLiteral;
import io.corbel.lib.queries.DoubleQueryLiteral;
import io.corbel.lib.queries.ListQueryLiteral;
import io.corbel.lib.queries.LongQueryLiteral;
import io.corbel.lib.queries.QueryNodeImpl;
import io.corbel.lib.queries.StringQueryLiteral;
import io.corbel.lib.queries.request.QueryLiteral;
import io.corbel.lib.queries.request.QueryNode;
import io.corbel.lib.queries.request.QueryOperator;
import io.corbel.lib.queries.request.ResourceQuery;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceQueryBuilder {
    private final ResourceQuery resourceQuery;

    public ResourceQueryBuilder(ResourceQuery resourceQuery) {
        this.resourceQuery = resourceQuery == null ? new ResourceQuery() : resourceQuery;
    }

    public ResourceQueryBuilder() {
        this(null);
    }

    public ResourceQueryBuilder add(String field, String value, QueryOperator operator) {
        StringQueryLiteral literal = new StringQueryLiteral(value);
        QueryNodeImpl queryNode = new QueryNodeImpl(operator, field, literal);
        this.resourceQuery.addQueryNode(queryNode);
        return this;
    }

    public ResourceQueryBuilder add(String field, String value) {
        return this.add(field, value, QueryOperator.$EQ);
    }

    public ResourceQueryBuilder add(String field, Date value, QueryOperator operator) {
        DateQueryLiteral literal = new DateQueryLiteral(value);
        QueryNodeImpl queryNode = new QueryNodeImpl(operator, field, literal);
        this.resourceQuery.addQueryNode(queryNode);
        return this;
    }

    public ResourceQueryBuilder add(String field, QueryOperator operator) {
        return this.add(field, Boolean.TRUE, operator);
    }

    public ResourceQueryBuilder add(String field, Boolean bool, QueryOperator operator) {
        BooleanQueryLiteral literal = new BooleanQueryLiteral();
        literal.setLiteral(bool);
        QueryNodeImpl queryNode = new QueryNodeImpl(operator, field, literal);
        this.resourceQuery.addQueryNode(queryNode);
        return this;
    }

    public ResourceQueryBuilder add(String field, List value, QueryOperator operator) {
        ListQueryLiteral literal = value == null || value.isEmpty() ? new ListQueryLiteral(value) : new ListQueryLiteral(this.listToQueryLiteralList(value));
        QueryNodeImpl queryNode = new QueryNodeImpl(operator, field, literal);
        this.resourceQuery.addQueryNode(queryNode);
        return this;
    }

    private List listToQueryLiteralList(List list) {
        Object elem = list.get(0);
        if (elem instanceof String) {
            return list.stream().map(e -> new StringQueryLiteral((String)e)).collect(Collectors.toList());
        }
        if (elem instanceof Boolean) {
            return list.stream().map(e -> new BooleanQueryLiteral((Boolean)e)).collect(Collectors.toList());
        }
        if (elem instanceof Double) {
            return list.stream().map(e -> new DoubleQueryLiteral((Double)e)).collect(Collectors.toList());
        }
        if (elem instanceof Long) {
            return list.stream().map(e -> new LongQueryLiteral((Long)e)).collect(Collectors.toList());
        }
        if (elem instanceof Integer) {
            return list.stream().map(e -> new LongQueryLiteral(new Long(e.intValue()))).collect(Collectors.toList());
        }
        if (elem instanceof Date) {
            return list.stream().map(e -> new DateQueryLiteral((Date)e)).collect(Collectors.toList());
        }
        if (elem instanceof QueryLiteral) {
            return list;
        }
        if (elem instanceof List) {
            return list.stream().map(e -> new ListQueryLiteral((List)e)).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException();
    }

    public ResourceQueryBuilder add(String field, Double value, QueryOperator operator) {
        DoubleQueryLiteral literal = new DoubleQueryLiteral(value);
        QueryNodeImpl queryNode = new QueryNodeImpl(operator, field, literal);
        this.resourceQuery.addQueryNode(queryNode);
        return this;
    }

    public ResourceQueryBuilder add(String field, Long value, QueryOperator operator) {
        LongQueryLiteral literal = new LongQueryLiteral(value);
        QueryNodeImpl queryNode = new QueryNodeImpl(operator, field, literal);
        this.resourceQuery.addQueryNode(queryNode);
        return this;
    }

    public ResourceQueryBuilder remove(String field) {
        Iterator<QueryNode> queryNodeIterator = this.resourceQuery.iterator();
        while (queryNodeIterator.hasNext()) {
            QueryNode queryNode = queryNodeIterator.next();
            if (!queryNode.getField().matches(field)) continue;
            queryNodeIterator.remove();
        }
        return this;
    }

    public ResourceQuery build() {
        return this.resourceQuery;
    }
}

