/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.jaxrs;

import io.corbel.lib.queries.request.Aggregation;
import io.corbel.lib.queries.request.Pagination;
import io.corbel.lib.queries.request.ResourceQuery;
import io.corbel.lib.queries.request.Search;
import io.corbel.lib.queries.request.Sort;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class QueryParameters {
    private Pagination pagination;
    private Optional<Sort> sort;
    private Optional<List<ResourceQuery>> queries;
    private Optional<List<ResourceQuery>> conditions;
    private Optional<Aggregation> aggregation;
    private Optional<Search> search;

    public QueryParameters(Pagination pagination, Optional<Sort> sort, Optional<List<ResourceQuery>> queries, Optional<List<ResourceQuery>> conditions, Optional<Aggregation> aggregation, Optional<Search> search) {
        this.pagination = pagination;
        this.sort = sort;
        this.queries = queries;
        this.conditions = conditions;
        this.aggregation = aggregation;
        this.search = search;
    }

    public QueryParameters(QueryParameters other) {
        this.pagination = other.pagination;
        this.sort = other.sort;
        this.queries = other.queries;
        this.conditions = other.conditions;
        this.aggregation = other.aggregation;
        this.search = other.search;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public Optional<Sort> getSort() {
        return this.sort;
    }

    public void setSort(Optional<Sort> sort) {
        this.sort = sort;
    }

    @Deprecated
    public Optional<ResourceQuery> getQuery() {
        return Optional.ofNullable(this.queries.map(queries -> (ResourceQuery)queries.get(0)).orElse(null));
    }

    public void setQuery(Optional<ResourceQuery> optionalQuery) {
        this.queries = Optional.ofNullable(optionalQuery.map(xva$0 -> Arrays.asList(xva$0)).orElse(null));
    }

    public Optional<List<ResourceQuery>> getQueries() {
        return this.queries;
    }

    public void setQueries(Optional<List<ResourceQuery>> listQueries) {
        this.queries = listQueries;
    }

    public Optional<List<ResourceQuery>> getConditions() {
        return this.conditions;
    }

    public void setConditions(Optional<List<ResourceQuery>> conditions) {
        this.conditions = conditions;
    }

    public Optional<Search> getSearch() {
        return this.search;
    }

    public void setSearch(Optional<Search> search) {
        this.search = search;
    }

    public Optional<Aggregation> getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Optional<Aggregation> aggregationOperation) {
        this.aggregation = aggregationOperation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregation == null ? 0 : this.aggregation.hashCode());
        result = 31 * result + (this.conditions == null ? 0 : this.conditions.hashCode());
        result = 31 * result + (this.pagination == null ? 0 : this.pagination.hashCode());
        result = 31 * result + (this.queries == null ? 0 : this.queries.hashCode());
        result = 31 * result + (this.search == null ? 0 : this.search.hashCode());
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryParameters other = (QueryParameters)obj;
        if (this.aggregation == null ? other.aggregation != null : !this.aggregation.equals(other.aggregation)) {
            return false;
        }
        if (this.conditions == null ? other.conditions != null : !this.conditions.equals(other.conditions)) {
            return false;
        }
        if (this.pagination == null ? other.pagination != null : !this.pagination.equals(other.pagination)) {
            return false;
        }
        if (this.queries == null ? other.queries != null : !this.queries.equals(other.queries)) {
            return false;
        }
        if (this.search == null ? other.search != null : !this.search.equals(other.search)) {
            return false;
        }
        return !(this.sort == null ? other.sort != null : !this.sort.equals(other.sort));
    }
}

