/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.matcher;

import io.corbel.lib.queries.exception.QueryMatchingException;
import io.corbel.lib.queries.matcher.QueryMatcher;
import io.corbel.lib.queries.request.QueryNode;
import io.corbel.lib.queries.request.QueryOperator;
import io.corbel.lib.queries.request.ResourceQuery;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;

public class DefaultQueryMatcher
implements QueryMatcher {
    @Override
    public boolean matchObject(ResourceQuery resourceQuery, Object object) throws QueryMatchingException {
        for (QueryNode queryNode : resourceQuery) {
            Object objectProperty;
            if (queryNode.getOperator() == QueryOperator.$EXISTS) {
                try {
                    objectProperty = this.getObjectProperty(object, queryNode.getField());
                    if (objectProperty != null) continue;
                    return false;
                }
                catch (QueryMatchingException e) {
                    return false;
                }
            }
            objectProperty = this.getObjectProperty(object, queryNode.getField());
            if (objectProperty == null) {
                return false;
            }
            if (queryNode.getValue().operate(queryNode.getOperator(), objectProperty, this)) continue;
            return false;
        }
        return true;
    }

    private Object getObjectProperty(Object object, String field) throws QueryMatchingException {
        try {
            return PropertyUtils.getProperty((Object)object, (String)field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new QueryMatchingException("Trying to access an invalid property.", e);
        }
    }
}

