/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.corbel.lib.queries.exception.MalformedJsonQueryException;
import io.corbel.lib.queries.parser.SearchParser;
import io.corbel.lib.queries.request.Search;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CustomSearchParser
implements SearchParser {
    private static final String INVALID_SEARCH_OBJECT = "Invalid Search Object";
    private static final String PARAMS = "params";
    private static final String TEMPLATE_NAME = "templateName";
    private final ObjectMapper mapper;

    public CustomSearchParser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Search parse(String searchString, boolean indexFieldsOnly) throws MalformedJsonQueryException {
        try {
            Map map = (Map)this.mapper.readValue(searchString, HashMap.class);
            return new Search(indexFieldsOnly, this.getTemplateName(map), this.getTemplateParams(map));
        }
        catch (ClassCastException e) {
            throw new MalformedJsonQueryException(e);
        }
        catch (IOException e) {
            return new Search(indexFieldsOnly, searchString);
        }
    }

    private Map<String, Object> getTemplateParams(Map<String, Object> map) throws MalformedJsonQueryException {
        Map params = (Map)map.get(PARAMS);
        if (params != null) {
            return params;
        }
        throw new MalformedJsonQueryException(INVALID_SEARCH_OBJECT);
    }

    private String getTemplateName(Map<String, Object> map) throws MalformedJsonQueryException {
        String name = (String)map.get(TEMPLATE_NAME);
        if (name != null) {
            return name;
        }
        throw new MalformedJsonQueryException(INVALID_SEARCH_OBJECT);
    }
}

