/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.request;

import io.corbel.lib.queries.request.QueryNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ResourceQuery
implements Iterable<QueryNode>,
Cloneable {
    private final List<QueryNode> conjunctions;

    public ResourceQuery() {
        this(new ArrayList<QueryNode>());
    }

    public ResourceQuery(List<QueryNode> conjunctions) {
        this.conjunctions = conjunctions;
    }

    public void addQueryNode(QueryNode queryNode) {
        this.conjunctions.add(queryNode);
    }

    @Override
    public Iterator<QueryNode> iterator() {
        return this.conjunctions.iterator();
    }

    public Set<String> getFilters() {
        return StreamSupport.stream(this.spliterator(), false).map(QueryNode::getField).collect(Collectors.toSet());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.conjunctions.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceQuery other = (ResourceQuery)obj;
        return this.conjunctions.equals(other.conjunctions);
    }

    public String toString() {
        return this.conjunctions.stream().map(this::parseQueryNode).collect(Collectors.joining(",", "[", "]"));
    }

    private String parseQueryNode(QueryNode query) {
        return "{\"" + query.getOperator().name().toLowerCase() + "\":{\"" + query.getField() + "\":" + query.getValue() + "}}";
    }

    public ResourceQuery clone() {
        return new ResourceQuery(new ArrayList<QueryNode>(this.conjunctions));
    }
}

