/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.request;

import java.util.Objects;

public class Sort {
    private Direction direction;
    private String field;

    public Sort(String direction, String field) {
        this.parseSortDirection(direction);
        this.field = field;
    }

    private void parseSortDirection(String directionString) {
        this.direction = Direction.valueOf(directionString.toUpperCase());
        if (this.direction == null) {
            throw new IllegalArgumentException();
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Sort)) {
            return false;
        }
        Sort that = (Sort)obj;
        return Objects.equals((Object)this.direction, (Object)that.getDirection()) && Objects.equals(this.field, that.getField());
    }

    public int hashCode() {
        int result = this.direction != null ? this.direction.hashCode() : 0;
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{\"" + this.getField() + "\":\"" + this.getDirection().name().toLowerCase() + "\"}";
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

