/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.eventbus.ioc;

import io.corbel.eventbus.ioc.EventBusIoc;
import io.corbel.eventbus.ioc.EventBusRegistrar;
import io.corbel.eventbus.service.DefaultIncomingEventProcessor;
import io.corbel.eventbus.service.EventBusRegistry;
import io.corbel.eventbus.service.InMemoryEventBusRegistry;
import io.corbel.eventbus.service.IncomingEventProcessor;
import io.corbel.lib.rabbitmq.config.AmqpConfiguration;
import io.corbel.lib.rabbitmq.config.BackoffOptions;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={EventBusIoc.class})
public class EventBusListeningIoc {
    @Autowired
    private Environment env;

    @Bean
    public EventBusRegistry eventBusRegistry() {
        return new InMemoryEventBusRegistry();
    }

    @Bean
    public IncomingEventProcessor incomingEventProcessor() {
        return new DefaultIncomingEventProcessor(this.eventBusRegistry());
    }

    @Bean
    public EventBusRegistrar eventBusRegistrar() {
        return new EventBusRegistrar(this.eventBusRegistry());
    }

    @Bean
    public ExecutorService threadPoolExecutor() {
        AtomicInteger threadCounter = new AtomicInteger(1);
        Integer threadsNumber = (Integer)this.env.getProperty("eventbus.concurrency", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 2));
        return Executors.newFixedThreadPool(threadsNumber, runnable -> new Thread(runnable, "eventbus-thread-" + threadCounter.getAndIncrement()));
    }

    @Bean
    public AmqpConfiguration eventBusListenerRabbitMQConfiguration(MessageListenerAdapter messageListenerAdapter) {
        ExecutorService threadPoolExecutor = this.threadPoolExecutor();
        return configurer -> {
            if (!this.isConsoleMode()) {
                String queueName = MessageFormat.format("eventbus.{0}.queue", this.env.getProperty("eventbus.listener.name"));
                configurer.bind("eventbus.exchange", configurer.queue(queueName), Optional.empty(), Optional.empty());
                SimpleMessageListenerContainer container = configurer.listenerContainer((Executor)threadPoolExecutor, configurer.setRetryOpertations(Optional.ofNullable(this.env.getProperty("eventbus.maxAttempts", Integer.class)), Optional.ofNullable(this.getBackoffOptions())), new String[]{queueName});
                container.setQueueNames(new String[]{queueName});
                container.setMessageListener((Object)messageListenerAdapter);
                container.start();
            }
        };
    }

    @Bean
    public MessageListenerAdapter getMessageListenerAdapter(MessageConverter messageConverter) {
        MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter((Object)this.incomingEventProcessor(), "process");
        messageListenerAdapter.setMessageConverter(messageConverter);
        return messageListenerAdapter;
    }

    private boolean isConsoleMode() {
        return Optional.ofNullable(System.getProperty("mode")).map(mode -> mode != null && mode.equals("console")).orElse(false);
    }

    private BackoffOptions getBackoffOptions() {
        Long intialInterval = (Long)this.env.getProperty("eventbus.backoff.initialInterval", Long.class);
        Double multiplier = (Double)this.env.getProperty("eventbus.backoff.multiplier", Double.class);
        Long maxInterval = (Long)this.env.getProperty("eventbus.backoff.maxInterval", Long.class);
        if (intialInterval == null || maxInterval == null || multiplier == null) {
            return null;
        }
        BackoffOptions backoffOptions = new BackoffOptions();
        backoffOptions.setInitialInterval(intialInterval.longValue());
        backoffOptions.setMultiplier(multiplier.doubleValue());
        backoffOptions.setMaxInterval(maxInterval.longValue());
        return backoffOptions;
    }
}

