/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.eventbus.ioc;

import io.corbel.eventbus.EventHandler;
import io.corbel.eventbus.service.EventBusRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EventBusRegistrar
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusRegistrar.class);
    private final EventBusRegistry registry;

    public EventBusRegistrar(EventBusRegistry registry) {
        this.registry = registry;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        for (EventHandler handler : context.getBeansOfType(EventHandler.class).values()) {
            LOG.info("Registering event handler {} for events of type {}", (Object)handler.getClass().getName(), (Object)handler.getEventType().getName());
            this.registry.register(handler);
        }
    }
}

