/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.eventbus.ioc;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import io.corbel.lib.rabbitmq.config.AmqpConfiguration;
import io.corbel.lib.rabbitmq.ioc.AbstractRabbitMQConfiguration;
import java.util.Optional;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class RabbitEventBusIoc
extends AbstractRabbitMQConfiguration {
    @Autowired
    private Environment env;

    @Bean(name={"eventBusAmqpTemplate"})
    public AmqpTemplate amqpTemplate() {
        return super.amqpTemplate();
    }

    @Bean
    public AmqpConfiguration eventBusRabbitMQConfiguration() {
        return configurer -> configurer.fanoutExchange("eventbus.exchange");
    }

    protected Environment getEnvironment() {
        return this.env;
    }

    @Bean
    public MessageConverter getDefaultMessageConverter() {
        Jackson2JsonMessageConverter jackson2JsonMessageConverter = new Jackson2JsonMessageConverter();
        jackson2JsonMessageConverter.setJsonObjectMapper(this.getObjectMapper());
        return jackson2JsonMessageConverter;
    }

    @Bean
    public ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new JSR310Module());
        return mapper;
    }

    protected MessageConverter getMessageConverter() {
        return this.getDefaultMessageConverter();
    }

    protected Optional<String> configPrefix() {
        return Optional.of("eventbus");
    }
}

