/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo;

import com.google.gson.JsonObject;
import com.mongodb.DBObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;

public class IdInjectorMongoEventListener
extends AbstractMongoEventListener<JsonObject> {
    private static final Logger LOG = LoggerFactory.getLogger(IdInjectorMongoEventListener.class);
    private static final String ID = "id";
    private static final String _ID = "_id";

    public void onAfterSave(JsonObject source, DBObject dbo) {
        if (dbo.containsField(_ID)) {
            String id = String.valueOf(dbo.get(_ID));
            LOG.debug("Adding id {} to object after saving", (Object)id);
            source.addProperty(ID, id);
        }
        super.onAfterSave((Object)source, dbo);
    }
}

