/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo.index;

import com.mongodb.DBObject;
import io.corbel.lib.mongo.index.IndexOptions;
import java.util.concurrent.TimeUnit;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;

public class MongoIndex {
    private final Index index = new Index();
    private final IndexOptions options = new IndexOptions();

    public MongoIndex on(String key, Sort.Direction direction) {
        this.index.on(key, direction);
        return this;
    }

    public MongoIndex named(String name) {
        this.options.setName(name);
        return this;
    }

    public MongoIndex unique() {
        this.options.setUnique(true);
        return this;
    }

    public MongoIndex sparse() {
        this.options.setSparse(true);
        return this;
    }

    public MongoIndex background() {
        this.options.setBackground(true);
        return this;
    }

    public MongoIndex dropDups() {
        this.options.setDropDups(true);
        return this;
    }

    public MongoIndex expires(int expire, TimeUnit timeUnit) {
        this.options.setExpire(expire, timeUnit);
        return this;
    }

    public IndexDefinition getIndexDefinition() {
        return new IndexDefinition(){

            public DBObject getIndexOptions() {
                return MongoIndex.this.options.getDBObject();
            }

            public DBObject getIndexKeys() {
                return MongoIndex.this.index.getIndexKeys();
            }
        };
    }
}

