/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo.repository.impl;

import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import io.corbel.lib.mongo.repository.PartialUpdateRepository;
import java.io.Serializable;
import java.util.Set;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.util.Assert;

public class ExtendedRepository<E, ID extends Serializable>
extends SimpleMongoRepository<E, ID>
implements PartialUpdateRepository<E, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<E, ID> metadata;

    public ExtendedRepository(MongoEntityInformation<E, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.mongoOperations = mongoOperations;
        this.metadata = metadata;
    }

    @Override
    public boolean patch(ID id, E data, String ... fieldsToDelete) {
        DBObject dbObject = this.getDbObject(data);
        return this.doUpdate(this.mongoOperations.getConverter().convertToMongoType(id), dbObject, fieldsToDelete);
    }

    @Override
    public boolean patch(E data, String ... fieldsToDelete) {
        DBObject dbObject = this.getDbObject(data);
        Object id = dbObject.get("_id");
        return this.doUpdate(id, dbObject, fieldsToDelete);
    }

    @Override
    public boolean upsert(ID id, E data) {
        Object idObject = this.mongoOperations.getConverter().convertToMongoType(id);
        DBObject dbObject = this.getDbObject(data);
        dbObject.removeField("_id");
        Update update = new Update();
        this.setField("", dbObject, update);
        return this.mongoOperations.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(idObject)), update, this.metadata.getCollectionName()).isUpdateOfExisting();
    }

    private DBObject getDbObject(E data) {
        Object mongoObject = this.mongoOperations.getConverter().convertToMongoType(data);
        if (!(mongoObject instanceof DBObject)) {
            throw new IllegalArgumentException("Object of type " + data.getClass() + " cannot be converted to DBObject");
        }
        DBObject dbObject = (DBObject)mongoObject;
        return dbObject;
    }

    private boolean doUpdate(Object id, DBObject data, String ... fieldsToDelete) {
        Assert.notNull((Object)id);
        data.removeField("_id");
        Update update = new Update();
        this.setField("", data, update);
        for (String field : fieldsToDelete) {
            update.unset(field);
        }
        WriteResult result = this.mongoOperations.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(id)), update, this.metadata.getCollectionName());
        return result.getN() != 0;
    }

    private void setField(String fieldPrefix, DBObject data, Update update) {
        Set keySet = data.keySet();
        for (String field : keySet) {
            Object value = data.get(field);
            if (value instanceof DBObject) {
                this.setField(field + ".", (DBObject)value, update);
                continue;
            }
            update.set(fieldPrefix + field, value);
        }
    }
}

