/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo.utils;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoCommonOperations {
    private static final String FIELD_ID = "_id";

    private MongoCommonOperations() {
    }

    public static String findStringFieldById(MongoOperations mongo, String field, String id, String collection) {
        Criteria criteria = Criteria.where((String)FIELD_ID).is((Object)id);
        Query query = Query.query((CriteriaDefinition)criteria);
        query.fields().include(field);
        DBObject json = (DBObject)mongo.findOne(query, DBObject.class, collection);
        return json == null ? null : json.get(field).toString();
    }

    public static <T> boolean exists(MongoOperations mongo, Map<String, Object> fields, Class<T> clazz) {
        Query query = Query.query((CriteriaDefinition)MongoCommonOperations.getCriterias(fields));
        return mongo.exists(query, clazz);
    }

    private static Criteria getCriterias(Map<String, Object> fields) {
        ArrayList<Criteria> criterias = new ArrayList<Criteria>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            criterias.add(Criteria.where((String)entry.getKey()).is(entry.getValue()));
        }
        switch (criterias.size()) {
            case 0: {
                return new Criteria();
            }
            case 1: {
                return (Criteria)criterias.get(0);
            }
        }
        return new Criteria().andOperator(criterias.toArray(new Criteria[criterias.size()]));
    }

    public static <T> void delete(MongoOperations mongo, Map<String, Object> fields, Class<T> clazz) {
        Query query = Query.query((CriteriaDefinition)MongoCommonOperations.getCriterias(fields));
        mongo.remove(query, clazz);
    }
}

