/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.backlog;

import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class Syslog4jBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected SyslogIF syslog = null;
    protected int downLevel = 4;
    protected int upLevel = 4;

    public Syslog4jBackLogHandler(String string) {
        this.syslog = Syslog.getInstance(string);
    }

    public Syslog4jBackLogHandler(String string, boolean bl) {
        this.syslog = Syslog.getInstance(string);
        this.appendReason = bl;
    }

    public Syslog4jBackLogHandler(SyslogIF syslogIF) {
        this.syslog = syslogIF;
    }

    public Syslog4jBackLogHandler(SyslogIF syslogIF, boolean bl) {
        this.syslog = syslogIF;
        this.appendReason = bl;
    }

    public void initialize() throws SyslogRuntimeException {
    }

    public void log(SyslogIF syslogIF, int n, String string, String string2) throws SyslogRuntimeException {
        if (this.syslog.getProtocol().equals(syslogIF.getProtocol())) {
            throw new SyslogRuntimeException("Ignoring this log entry since the backLog protocol \"" + this.syslog.getProtocol() + "\" is the same as the main protocol");
        }
        String string3 = this.combine(syslogIF, n, string, string2);
        this.syslog.log(n, string3);
    }

    public void down(SyslogIF syslogIF, String string) {
        if (!this.syslog.getProtocol().equals(syslogIF.getProtocol())) {
            this.syslog.log(this.downLevel, "Syslog protocol \"" + syslogIF.getProtocol() + "\" is down: " + string);
        }
    }

    public void up(SyslogIF syslogIF) {
        if (!this.syslog.getProtocol().equals(syslogIF.getProtocol())) {
            this.syslog.log(this.downLevel, "Syslog protocol \"" + syslogIF.getProtocol() + "\" is up");
        }
    }
}

