/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.rabbitmq.config;

import io.corbel.lib.rabbitmq.config.BackoffOptions;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.config.RetryInterceptorBuilder;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.rabbit.retry.RejectAndDontRequeueRecoverer;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.util.ErrorHandler;

public interface AmqpConfigurer {
    public TopicExchange topicExchange(String var1, UnaryOperator<Exchange> var2);

    default public TopicExchange topicExchange(String name) {
        return this.topicExchange(name, null);
    }

    public FanoutExchange fanoutExchange(String var1, UnaryOperator<Exchange> var2);

    default public FanoutExchange fanoutExchange(String name) {
        return this.fanoutExchange(name, null);
    }

    public UnaryOperator<Exchange> alternateExchange(String var1);

    default public UnaryOperator<Exchange> alternateExchange(Exchange alterExchange) {
        return this.alternateExchange(alterExchange.getName());
    }

    public Queue queue(String var1, Function<Queue, Queue> ... var2);

    default public Queue queue(String name) {
        return this.queue(name, null);
    }

    public void bind(String var1, String var2, Binding.DestinationType var3, Optional<String> var4, Optional<Map<String, Object>> var5);

    default public void bind(String exchangeName, Queue destination, Optional<String> routingKey, Optional<Map<String, Object>> arguments) {
        this.bind(exchangeName, destination.getName(), Binding.DestinationType.QUEUE, routingKey, arguments);
    }

    public UnaryOperator<Queue> setDeadLetterExchange(String var1);

    default public UnaryOperator<Queue> setDeadLetterExchange(Exchange exchange) {
        return this.setDeadLetterExchange(exchange.getName());
    }

    public UnaryOperator<Queue> setTimeToLive(int var1);

    public SimpleMessageListenerContainer listenerContainer(Executor var1, UnaryOperator<SimpleMessageListenerContainer> var2, String ... var3);

    default public SimpleMessageListenerContainer listenerContainer(UnaryOperator<SimpleMessageListenerContainer> modifier, String ... queueNames) {
        return this.listenerContainer((Executor)Executors.newSingleThreadExecutor(), modifier, queueNames);
    }

    default public SimpleMessageListenerContainer listenerContainer(String ... queueNames) {
        return this.listenerContainer((Executor)Executors.newSingleThreadExecutor(), (UnaryOperator<SimpleMessageListenerContainer>)null, queueNames);
    }

    default public SimpleMessageListenerContainer listenerContainer(Executor executor, String ... queueNames) {
        return this.listenerContainer(executor, (UnaryOperator<SimpleMessageListenerContainer>)null, queueNames);
    }

    public UnaryOperator<SimpleMessageListenerContainer> setRetryOpertations(RetryOperationsInterceptor var1);

    public UnaryOperator<SimpleMessageListenerContainer> setErrorHandler(ErrorHandler var1);

    default public UnaryOperator<SimpleMessageListenerContainer> setRetryOpertations(Optional<Integer> maxAttempts, Optional<BackoffOptions> backoffOptions) {
        RetryInterceptorBuilder.StatelessRetryInterceptorBuilder builder = RetryInterceptorBuilder.stateless();
        if (maxAttempts.isPresent()) {
            builder.maxAttempts(maxAttempts.get().intValue());
        }
        if (backoffOptions.isPresent()) {
            BackoffOptions options = backoffOptions.get();
            builder.backOffOptions(options.getInitialInterval(), options.getMultiplier(), options.getMaxInterval());
        }
        builder.recoverer((MessageRecoverer)new RejectAndDontRequeueRecoverer());
        return this.setRetryOpertations(builder.build());
    }
}

