/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.rabbitmq.ioc;

import io.corbel.lib.rabbitmq.config.AmqpConfigurer;
import io.corbel.lib.rabbitmq.config.RabbitMQConfigurer;
import io.corbel.lib.rabbitmq.ioc.AmqpConfigurationBeanPostProcessor;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public abstract class AbstractRabbitMQConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRabbitMQConfiguration.class);

    @Bean
    public AmqpTemplate amqpTemplate() {
        RabbitTemplate template = new RabbitTemplate(this.connectionFactory());
        MessageConverter messageConverters = this.getMessageConverter();
        if (messageConverters != null) {
            template.setMessageConverter(messageConverters);
        }
        return template;
    }

    @Bean
    public ConnectionFactory connectionFactory() {
        String virtualHost;
        Integer connectionTimeout;
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(this.getRabbitHost(), this.getRabbitPort());
        connectionFactory.setUsername(this.getRabbitUsername());
        connectionFactory.setPassword(this.getRabbitPassword());
        Integer requestedHeartbeat = this.getRequestedHeartbeat();
        if (requestedHeartbeat != null) {
            connectionFactory.setRequestedHeartBeat(requestedHeartbeat.intValue());
        }
        if ((connectionTimeout = this.getConnectionTimeout()) != null) {
            connectionFactory.setCloseTimeout(connectionTimeout.intValue());
        }
        if ((virtualHost = this.getVirtualHost()) != null) {
            connectionFactory.setVirtualHost(virtualHost);
        }
        return connectionFactory;
    }

    @Bean
    public RabbitAdmin rabbitAdmin() {
        return new RabbitAdmin(this.connectionFactory());
    }

    @Bean
    public AmqpConfigurer amqpConfigurer() {
        return new RabbitMQConfigurer(this.rabbitAdmin(), this.connectionFactory());
    }

    @Bean
    public AmqpConfigurationBeanPostProcessor amqpConfigurationBeanPostProcessor() {
        return new AmqpConfigurationBeanPostProcessor(this.amqpConfigurer());
    }

    protected abstract Environment getEnvironment();

    protected Optional<String> configPrefix() {
        return Optional.empty();
    }

    protected MessageConverter getMessageConverter() {
        return null;
    }

    protected String getRabbitHost() {
        return this.getEnvironment().getProperty(this.configKey("rabbitmq.host"));
    }

    protected int getRabbitPort() {
        return (Integer)this.getEnvironment().getProperty(this.configKey("rabbitmq.port"), Integer.class);
    }

    protected String getRabbitUsername() {
        return (String)this.getEnvironment().getProperty(this.configKey("rabbitmq.username"), String.class);
    }

    protected String getRabbitPassword() {
        return (String)this.getEnvironment().getProperty(this.configKey("rabbitmq.password"), String.class);
    }

    protected Integer getRequestedHeartbeat() {
        return (Integer)this.getEnvironment().getProperty(this.configKey("rabbitmq.requestedHeartbeat"), Integer.class);
    }

    protected Integer getConnectionTimeout() {
        return (Integer)this.getEnvironment().getProperty(this.configKey("rabbitmq.connectionTimeout"), Integer.class);
    }

    protected String getVirtualHost() {
        return (String)this.getEnvironment().getProperty(this.configKey("rabbitmq.virtualHost"), String.class);
    }

    private String configKey(String keyName) {
        return this.configPrefix().map(prefix -> prefix + ".").orElse("").concat(keyName);
    }
}

