/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;

public class FuzzyEnumModule
extends Module {
    public String getModuleName() {
        return "permissive-enums";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new PermissiveEnumDeserializers());
    }

    private static class PermissiveEnumDeserializers
    extends Deserializers.Base {
        private PermissiveEnumDeserializers() {
        }

        public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription desc) throws JsonMappingException {
            List factoryMethods = desc.getFactoryMethods();
            if (factoryMethods != null) {
                for (AnnotatedMethod am : factoryMethods) {
                    JsonCreator creator = (JsonCreator)am.getAnnotation(JsonCreator.class);
                    if (creator == null) continue;
                    return EnumDeserializer.deserializerForCreator((DeserializationConfig)config, type, (AnnotatedMethod)am);
                }
            }
            return new PermissiveEnumDeserializer(type);
        }
    }

    private static class PermissiveEnumDeserializer
    extends StdScalarDeserializer<Enum<?>> {
        private static final long serialVersionUID = 1L;
        private final Enum<?>[] constants = (Enum[])this.handledType().getEnumConstants();
        private final List<String> acceptedValues = Lists.newArrayList();

        protected PermissiveEnumDeserializer(Class<Enum<?>> clazz) {
            super(clazz);
            for (Enum<?> constant : this.constants) {
                this.acceptedValues.add(constant.name());
            }
        }

        public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = CharMatcher.WHITESPACE.removeFrom((CharSequence)jp.getText()).replace('-', '_').replace('.', '_');
            for (Enum<?> constant : this.constants) {
                if (!constant.name().equalsIgnoreCase(text)) continue;
                return constant;
            }
            throw ctxt.mappingException(text + " was not one of " + this.acceptedValues);
        }
    }
}

