/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.rem.plugin;

import com.github.zafarkhaja.semver.Version;
import io.corbel.resources.rem.RemRegistry;
import io.corbel.resources.rem.exception.InitializationRemException;
import io.corbel.resources.rem.model.Mode;
import io.corbel.resources.rem.plugin.HealthCheckRegistry;
import io.corbel.resources.rem.plugin.PluginArtifactIdRegistry;
import io.corbel.resources.rem.plugin.RelationRegistry;
import io.corbel.resources.rem.service.RemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public abstract class RemPlugin
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(RemPlugin.class);
    @Autowired
    protected Mode mode;
    @Autowired
    protected RemService remService;
    @Autowired
    protected RemRegistry registry;
    @Autowired
    protected RelationRegistry relationRegistry;
    @Autowired
    protected HealthCheckRegistry healthCheckRegistry;
    @Autowired
    private PluginArtifactIdRegistry pluginArtifactIdRegistry;
    @Value(value="${platform.version}")
    protected String version;
    @Value(value="${resources.plugins.resilient}")
    private boolean resilient;
    protected ApplicationContext context;

    public final void afterPropertiesSet() throws Exception {
        if (Mode.SERVICE.equals((Object)this.mode)) {
            try {
                this.init();
                this.checkVersion();
                this.register(this.registry);
                this.addRelations(this.relationRegistry);
                this.addHealthCheck(this.healthCheckRegistry);
                this.pluginArtifactIdRegistry.addPluginArtifactId(this.getArtifactName());
            }
            catch (Exception e) {
                if (this.resilient) {
                    LOG.error("Error with " + this.getClass().getSimpleName(), (Throwable)e);
                }
                throw e;
            }
        } else {
            this.console();
        }
    }

    protected void checkVersion() {
        String version = this.context.getEnvironment().getProperty("platform.version");
        if (version != null && Version.valueOf((String)version).getMajorVersion() != Version.valueOf((String)this.version).getMajorVersion()) {
            throw new InitializationRemException("Problem with rem init: current platform version is " + this.version + " but rem uses " + version);
        }
    }

    protected void init() {
    }

    protected void console() {
    }

    protected abstract void register(RemRegistry var1);

    protected void addRelations(RelationRegistry linkRegistry) {
    }

    protected void addHealthCheck(HealthCheckRegistry healthCheckRegistry) {
    }

    protected abstract String getArtifactName();
}

