/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.rem.request;

import io.corbel.lib.token.TokenInfo;
import io.corbel.resources.rem.request.RequestParameters;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.springframework.http.MediaType;

public class RequestParametersImpl<E>
implements RequestParameters<E> {
    private final E apiParameters;
    private final TokenInfo tokenInfo;
    private final String requestedDomain;
    private final List<MediaType> acceptedMediaTypes;
    private final MultivaluedMap<String, String> params;
    private final Long contentLength;
    private final MultivaluedMap<String, String> headers;

    public RequestParametersImpl(E apiParameters, TokenInfo tokenInfo, String requestedDomain, List<MediaType> acceptedMediaTypes, Long contentLength, MultivaluedMap<String, String> params, MultivaluedMap<String, String> headers) {
        this.apiParameters = apiParameters;
        this.tokenInfo = tokenInfo;
        this.requestedDomain = requestedDomain;
        this.acceptedMediaTypes = acceptedMediaTypes;
        this.contentLength = contentLength;
        this.params = params;
        this.headers = headers;
    }

    @Override
    public E getApiParameters() {
        return this.apiParameters;
    }

    @Override
    public TokenInfo getTokenInfo() {
        return this.tokenInfo;
    }

    @Override
    public String getRequestedDomain() {
        return this.requestedDomain;
    }

    @Override
    public List<MediaType> getAcceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }

    @Override
    public String getCustomParameterValue(String parameterName) {
        return this.params != null ? (String)this.params.getFirst((Object)parameterName) : null;
    }

    @Override
    public List<String> getCustomParameterValues(String parameterName) {
        return this.params != null ? (List)this.params.get((Object)parameterName) : null;
    }

    @Override
    public MultivaluedMap<String, String> getParams() {
        return this.params;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acceptedMediaTypes == null ? 0 : this.acceptedMediaTypes.hashCode());
        result = 31 * result + (this.apiParameters == null ? 0 : this.apiParameters.hashCode());
        result = 31 * result + (this.contentLength == null ? 0 : this.contentLength.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.tokenInfo == null ? 0 : this.tokenInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestParametersImpl other = (RequestParametersImpl)obj;
        if (this.acceptedMediaTypes == null ? other.acceptedMediaTypes != null : !this.acceptedMediaTypes.equals(other.acceptedMediaTypes)) {
            return false;
        }
        if (this.apiParameters == null ? other.apiParameters != null : !this.apiParameters.equals(other.apiParameters)) {
            return false;
        }
        if (this.contentLength == null ? other.contentLength != null : !this.contentLength.equals(other.contentLength)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.tokenInfo == null ? other.tokenInfo != null : !this.tokenInfo.equals((Object)other.tokenInfo));
    }
}

