/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.rem.internal;

import io.corbel.resources.rem.plugin.RelationRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class InMemoryRelationRegistry
implements RelationRegistry {
    private final Map<String, Map<String, Set<String>>> relationFields = new ConcurrentHashMap<String, Map<String, Set<String>>>();

    public void addTypeRelation(String type, Set<String> relations) {
        for (String relation : relations) {
            this.addRelationFields(type, relation, new HashSet<String>());
        }
    }

    public Set<String> getTypeRelations(String type) {
        Map<String, Set<String>> map = this.relationFields.get(type);
        return map != null ? new HashSet<String>(map.keySet()) : new HashSet();
    }

    public void addRelationFields(String type, String relation, Set<String> fields) {
        Set<String> fieldsSet;
        Map<String, Set<String>> typeRelations = this.relationFields.get(type);
        if (typeRelations == null) {
            typeRelations = new HashMap<String, Set<String>>();
            this.relationFields.put(type, typeRelations);
        }
        if ((fieldsSet = typeRelations.get(relation)) == null) {
            fieldsSet = new HashSet<String>();
            typeRelations.put(relation, fieldsSet);
        }
        fieldsSet.addAll(fields);
    }

    public Set<String> getRelationFields(String type, String relation) {
        Map<String, Set<String>> map = this.relationFields.get(type);
        return map != null ? map.get(relation) : new HashSet();
    }
}

