/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.rem.internal;

import io.corbel.resources.rem.Rem;
import io.corbel.resources.rem.RemRegistry;
import io.corbel.resources.rem.model.RemDescription;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

public class InMemoryRemRegistry
implements RemRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryRemRegistry.class);
    private AtomicReference<MemoryRegistry> memoryRegistry = new AtomicReference<MemoryRegistry>(new MemoryRegistry(new TreeSet<UriPatternRegistryEntry>(), new HashMap<String, UriPatternRegistryEntry>()));

    public Rem getRem(String uri, List<MediaType> acceptableMediaTypes, HttpMethod method, List<Rem> remsExcluded) {
        for (UriPatternRegistryEntry entry : this.memoryRegistry.get().getRegistry()) {
            if (!entry.matches(uri)) continue;
            for (MediaType mediaType : acceptableMediaTypes) {
                List<MediaTypeRegistryEntry> mediaTypeRegistryEntries = entry.get(mediaType);
                for (MediaTypeRegistryEntry mediaTypeRegistryEntry : mediaTypeRegistryEntries) {
                    Rem rem = mediaTypeRegistryEntry.get(method);
                    if (rem == null || remsExcluded != null && remsExcluded.contains(rem)) continue;
                    return rem;
                }
            }
        }
        LOG.info("No REM found for URI={}, MediaTypes={}, Method={}", new Object[]{uri, acceptableMediaTypes, method});
        return null;
    }

    public void unregisterRem(Class<?> remClass, String uriPattern, MediaType mediaType) {
        HashMap<String, UriPatternRegistryEntry> newRegistryLookUp;
        TreeSet<UriPatternRegistryEntry> newRegistry;
        MemoryRegistry newMemoryRegistry;
        MemoryRegistry currentMemoryRegistry;
        do {
            Map<String, UriPatternRegistryEntry> registryLookUp;
            Optional<UriPatternRegistryEntry> uriPatternRegistryEntryFound;
            if (!(uriPatternRegistryEntryFound = Optional.ofNullable((registryLookUp = (currentMemoryRegistry = this.memoryRegistry.get()).getRegistryLookUp()).get(uriPattern))).isPresent()) {
                return;
            }
            newRegistry = new TreeSet<UriPatternRegistryEntry>(currentMemoryRegistry.getRegistry());
            newRegistryLookUp = new HashMap<String, UriPatternRegistryEntry>(registryLookUp);
            UriPatternRegistryEntry registryEntryInNewRegistryLookUp = (UriPatternRegistryEntry)newRegistryLookUp.get(uriPattern);
            if (!registryEntryInNewRegistryLookUp.removeAndCheckIfEmpty(remClass, mediaType)) continue;
            newRegistryLookUp.remove(uriPattern);
            newRegistry.remove(registryEntryInNewRegistryLookUp);
        } while (!this.memoryRegistry.weakCompareAndSet(currentMemoryRegistry, newMemoryRegistry = new MemoryRegistry(newRegistry, newRegistryLookUp)));
    }

    public List<RemDescription> getRegistryDescription() {
        LinkedList<RemDescription> descriptionsList = new LinkedList<RemDescription>();
        for (UriPatternRegistryEntry uriPatternRegistryEntry : this.memoryRegistry.get().getRegistry()) {
            for (MediaTypeRegistryEntry mediaTypeRegistryEntry : uriPatternRegistryEntry.getMediaTypeRegistryEntries()) {
                Map<HttpMethod, Rem> remRegistry = mediaTypeRegistryEntry.getRemRegistry();
                for (HttpMethod httpMethod : remRegistry.keySet()) {
                    RemDescription remDescription = new RemDescription(remRegistry.get(httpMethod).getClass().getName(), httpMethod.name(), mediaTypeRegistryEntry.getMediaType().toString(), uriPatternRegistryEntry.getUriPattern().pattern());
                    descriptionsList.add(remDescription);
                }
            }
        }
        return descriptionsList;
    }

    public void registerRem(Rem rem, String uriPattern, MediaType mediaType, HttpMethod ... methods) {
        MemoryRegistry newMemoryRegistry;
        MemoryRegistry currentMemoryRegistry;
        do {
            currentMemoryRegistry = this.memoryRegistry.get();
            HashMap<String, UriPatternRegistryEntry> registryLookUp = new HashMap<String, UriPatternRegistryEntry>(currentMemoryRegistry.getRegistryLookUp());
            TreeSet<UriPatternRegistryEntry> registry = new TreeSet<UriPatternRegistryEntry>(currentMemoryRegistry.getRegistry());
            Object[] methodsToAdd = methods == null || methods.length == 0 ? HttpMethod.values() : methods;
            UriPatternRegistryEntry registryEntry = (UriPatternRegistryEntry)registryLookUp.get(uriPattern);
            if (registryEntry == null) {
                registryEntry = new UriPatternRegistryEntry(uriPattern);
                registryLookUp.put(uriPattern, registryEntry);
                registryEntry.add(rem, mediaType, (HttpMethod[])methodsToAdd);
                registry.add(registryEntry);
            } else {
                registryEntry.add(rem, mediaType, (HttpMethod[])methodsToAdd);
            }
            newMemoryRegistry = new MemoryRegistry(registry, registryLookUp);
            LOG.info("Registered REM {}: URI={} , MediaType={}, Methods={}", new Object[]{rem, uriPattern, mediaType.toString(), Arrays.toString(methodsToAdd)});
        } while (!this.memoryRegistry.weakCompareAndSet(currentMemoryRegistry, newMemoryRegistry));
    }

    public void registerRem(Rem rem, String uriPattern, HttpMethod ... methods) {
        this.registerRem(rem, uriPattern, MediaType.ALL, methods);
    }

    public Rem getRem(String name) {
        SortedSet<UriPatternRegistryEntry> currentRegistry = this.memoryRegistry.get().getRegistry();
        for (UriPatternRegistryEntry entry : currentRegistry) {
            for (MediaTypeRegistryEntry mediaTypeRegistry : entry.getMediaTypeRegistryEntries()) {
                for (Rem rem : mediaTypeRegistry.getRems()) {
                    if (!rem.getClass().getSimpleName().equals(name)) continue;
                    return rem;
                }
            }
        }
        return null;
    }

    private class UriPatternRegistryEntry
    implements Comparable<UriPatternRegistryEntry> {
        private final Pattern uriPattern;
        private final SortedSet<MediaTypeRegistryEntry> mediaTypeRegistry = new TreeSet(Collections.reverseOrder());
        private final Map<MediaType, MediaTypeRegistryEntry> mediaTypeRegistryLookUp = new HashMap<MediaType, MediaTypeRegistryEntry>();

        public UriPatternRegistryEntry(String uriPattern) {
            this(uriPattern == null ? null : Pattern.compile(uriPattern));
        }

        public UriPatternRegistryEntry(Pattern uriPattern) {
            if (uriPattern == null) {
                throw new IllegalArgumentException("Invalid uri pattern: null");
            }
            this.uriPattern = uriPattern;
        }

        public boolean matches(String uri) {
            return this.uriPattern.matcher(uri).matches();
        }

        public void add(Rem rem, MediaType mediaType, HttpMethod[] methods) {
            MediaTypeRegistryEntry entry = this.mediaTypeRegistryLookUp.get(mediaType);
            if (entry == null) {
                entry = new MediaTypeRegistryEntry(mediaType);
                this.mediaTypeRegistry.add(entry);
                this.mediaTypeRegistryLookUp.put(mediaType, entry);
            }
            entry.add(rem, methods);
        }

        public boolean removeAndCheckIfEmpty(Class<?> remClass, MediaType mediaType) {
            List<Map.Entry> entriesToRemove = this.mediaTypeRegistryLookUp.entrySet().stream().filter(entry -> ((MediaType)entry.getKey()).equals((Object)mediaType)).filter(entry -> ((MediaTypeRegistryEntry)entry.getValue()).removeAndCheckIfEmpty(remClass)).collect(Collectors.toList());
            entriesToRemove.forEach(entry -> {
                this.mediaTypeRegistryLookUp.remove(entry.getKey());
                this.mediaTypeRegistry.remove(entry.getValue());
            });
            return this.mediaTypeRegistry.isEmpty();
        }

        public List<MediaTypeRegistryEntry> get(MediaType mediaType) {
            return this.mediaTypeRegistry.stream().filter(entry -> entry.matches(mediaType)).collect(Collectors.toList());
        }

        public Collection<MediaTypeRegistryEntry> getMediaTypeRegistryEntries() {
            return this.mediaTypeRegistry;
        }

        public Pattern getUriPattern() {
            return this.uriPattern;
        }

        @Override
        public int compareTo(UriPatternRegistryEntry o) {
            if (this.uriPattern.matcher(o.uriPattern.pattern()).matches()) {
                if (o.uriPattern.matcher(this.uriPattern.pattern()).matches()) {
                    if (!this.mediaTypeRegistry.isEmpty()) {
                        return o.mediaTypeRegistry.first().compareTo(this.mediaTypeRegistry.first());
                    }
                    return 0;
                }
                return 1;
            }
            return -1;
        }
    }

    private class MediaTypeRegistryEntry
    implements Comparable<MediaTypeRegistryEntry> {
        private final MediaType mediaType;
        private final Map<HttpMethod, Rem> remRegistry = new HashMap<HttpMethod, Rem>();

        public MediaTypeRegistryEntry(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public boolean matches(MediaType obj) {
            return this.mediaType.includes(obj);
        }

        public Rem get(HttpMethod method) {
            return this.remRegistry.get(method);
        }

        public void add(Rem rem, HttpMethod[] methods) {
            for (HttpMethod method : methods) {
                this.remRegistry.put(method, rem);
            }
        }

        public boolean removeAndCheckIfEmpty(Class<?> remClass) {
            List<HttpMethod> keysToRemove = this.remRegistry.entrySet().stream().filter(entry -> ((Rem)entry.getValue()).getClass().equals(remClass)).map(Map.Entry::getKey).collect(Collectors.toList());
            keysToRemove.forEach(this.remRegistry::remove);
            return this.remRegistry.isEmpty();
        }

        public Collection<Rem> getRems() {
            return this.remRegistry.values();
        }

        public Map<HttpMethod, Rem> getRemRegistry() {
            return this.remRegistry;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        @Override
        public int compareTo(MediaTypeRegistryEntry o) {
            return this.mediaType.compareTo((MimeType)o.mediaType);
        }
    }

    private static class MemoryRegistry {
        private final SortedSet<UriPatternRegistryEntry> registry;
        private final Map<String, UriPatternRegistryEntry> registryLookUp;

        public MemoryRegistry(SortedSet<UriPatternRegistryEntry> registry, Map<String, UriPatternRegistryEntry> registryLookUp) {
            this.registry = registry;
            this.registryLookUp = registryLookUp;
        }

        public SortedSet<UriPatternRegistryEntry> getRegistry() {
            return this.registry;
        }

        public Map<String, UriPatternRegistryEntry> getRegistryLookUp() {
            return this.registryLookUp;
        }
    }
}

