/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources;

import io.corbel.lib.cli.console.Console;
import io.corbel.lib.cli.console.Shell;
import io.corbel.lib.ws.log.LogbackUtils;
import io.corbel.resources.ioc.ResourcesIoc;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ResourcesConsoleRunner
extends Console {
    public ResourcesConsoleRunner() {
        super("Welcome to SilkRoad Resources. Type resources.help() to start.", ResourcesConsoleRunner.createShell());
    }

    private static Map<String, Object> createShell() {
        System.setProperty("mode", "console");
        System.setProperty("conf.namespace", "resources");
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{ResourcesIoc.class});
        Map beans = applicationContext.getBeansWithAnnotation(Shell.class);
        HashMap<String, Object> shells = new HashMap<String, Object>(beans.size());
        beans.forEach((beanName, bean) -> shells.put(((Shell)applicationContext.findAnnotationOnBean(beanName, Shell.class)).value(), bean));
        return shells;
    }

    public static void main(String[] args) {
        LogbackUtils.setLogLevel((String)"INFO");
        ResourcesConsoleRunner console = new ResourcesConsoleRunner();
        try {
            if (args.length == 0) {
                console.launch();
            } else {
                console.runScripts(args);
            }
            System.exit(0);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

