/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import io.corbel.lib.ws.cli.CommandLineI;
import io.corbel.lib.ws.cli.GenericConsole;
import io.corbel.lib.ws.cli.ServiceRunnerWithVersionResource;
import io.corbel.lib.ws.filter.ETagResponseFilter;
import io.corbel.lib.ws.health.AuthorizationRedisHealthCheck;
import io.corbel.lib.ws.health.BasicHealthCheck;
import io.corbel.lib.ws.health.MongoHealthCheck;
import io.corbel.resources.api.PluginInfoResource;
import io.corbel.resources.api.RemResource;
import io.corbel.resources.ioc.ResourcesIoc;
import io.corbel.resources.rem.plugin.HealthCheckRegistry;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ResourcesRunner
extends ServiceRunnerWithVersionResource<ResourcesIoc> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesRunner.class);

    public static void main(String[] args) {
        try {
            ResourcesRunner resourcesRunner = new ResourcesRunner();
            resourcesRunner.setCommandLine(ResourcesRunner.createConsoleCommandLine(resourcesRunner));
            resourcesRunner.run(args);
        }
        catch (Exception e) {
            LOG.error("Unable to start resource", (Throwable)e);
        }
    }

    protected String getArtifactId() {
        return "resources";
    }

    protected void configureService(Environment environment, ApplicationContext context) {
        super.configureService(environment, context);
        environment.jersey().register(context.getBean(RemResource.class));
        environment.jersey().register(context.getBean(PluginInfoResource.class));
        environment.jersey().register(ETagResponseFilter.class);
        environment.healthChecks().register("basic", (HealthCheck)new BasicHealthCheck());
        environment.healthChecks().register("redis", (HealthCheck)context.getBean(AuthorizationRedisHealthCheck.class));
        environment.healthChecks().register("mongo", (HealthCheck)context.getBean(MongoHealthCheck.class));
        HealthCheckRegistry healthCheckRegistry = (HealthCheckRegistry)context.getBean(HealthCheckRegistry.class);
        healthCheckRegistry.getHealthChecks().forEach((k, v) -> environment.healthChecks().register(k, v));
    }

    protected void configureObjectMapper(ObjectMapper objectMapperFactory) {
        objectMapperFactory.registerModule((Module)new DefaultScalaModule());
        super.configureObjectMapper(objectMapperFactory);
    }

    private static CommandLineI createConsoleCommandLine(ResourcesRunner resourcesRunner) {
        return new GenericConsole(resourcesRunner.getArtifactId(), ResourcesIoc.class);
    }
}

