/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.api;

import io.corbel.resources.model.PluginInfo;
import io.corbel.resources.rem.plugin.PluginArtifactIdRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
@Path(value="/plugins")
public class PluginInfoResource {
    private static final Logger LOG = LoggerFactory.getLogger(PluginInfoResource.class);
    private final List<String> propertyFiles = new ArrayList<String>();
    private final List<PluginInfo> pluginsInfo;

    public PluginInfoResource(PluginArtifactIdRegistry pluginArtifactIdRegistry) {
        pluginArtifactIdRegistry.getPluginsArtifactId().stream().forEach(artifactId -> this.propertyFiles.add("/META-INF/" + artifactId + "-plugin-build.properties"));
        this.pluginsInfo = this.getPluginsInfo();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getPluginInfo() {
        return Response.ok().entity(this.pluginsInfo).build();
    }

    private List<PluginInfo> getPluginsInfo() {
        List<Properties> buildMetadataProperties = this.loadBuildMetadataProperties();
        ArrayList<PluginInfo> pluginsInfo = new ArrayList<PluginInfo>();
        buildMetadataProperties.stream().forEach(properties -> pluginsInfo.add(new PluginInfo(properties.getProperty("build.artifactId"), properties.getProperty("build.version"))));
        return pluginsInfo;
    }

    private List<Properties> loadBuildMetadataProperties() {
        ArrayList<Properties> buildMetadataProperties = new ArrayList<Properties>();
        for (String propertyFile : this.propertyFiles) {
            try {
                InputStream buildPropertiesStream = PluginInfoResource.class.getResourceAsStream(propertyFile);
                Throwable throwable = null;
                try {
                    if (buildPropertiesStream == null) continue;
                    Properties prop = new Properties();
                    prop.load(buildPropertiesStream);
                    buildMetadataProperties.add(prop);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (buildPropertiesStream == null) continue;
                    if (throwable != null) {
                        try {
                            buildPropertiesStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    buildPropertiesStream.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Problem loading metadata file: " + propertyFile, (Throwable)e);
            }
        }
        return buildMetadataProperties;
    }
}

