/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.api;

import io.corbel.lib.queries.jaxrs.QueryParameters;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.ws.annotation.Rest;
import io.corbel.lib.ws.auth.AuthorizationInfo;
import io.corbel.resources.rem.request.ResourceId;
import io.corbel.resources.service.ResourcesService;
import io.dropwizard.auth.Auth;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

@Resource
@Path(value="v1.0/{domain}/resource")
public class RemResource {
    private static final Logger LOG = LoggerFactory.getLogger(RemResource.class);
    private final ResourcesService resourcesService;

    public RemResource(ResourcesService resourcesService) {
        this.resourcesService = resourcesService;
    }

    @Context
    public void setProviders(Providers providers) {
        this.resourcesService.setProviders(providers);
    }

    @GET
    @Path(value="/{type}")
    public Response getCollection(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @Rest QueryParameters queryParameters) {
        URI typeUri = this.getBaseUriWithType(uriInfo, domain, type);
        this.updateRequestWithLinksTypeAndUri(request, typeUri, type);
        return this.resourcesService.collectionOperation(domain, type, request, uriInfo, this.getTokenInfo(authorizationInfo), typeUri, HttpMethod.GET, queryParameters, null, null);
    }

    @POST
    @Path(value="/{type}")
    public Response postCollection(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, InputStream inputStream, @HeaderParam(value="Content-Type") MediaType contentType) {
        return this.resourcesService.collectionOperation(domain, type, request, uriInfo, this.getTokenInfo(authorizationInfo), this.getBaseUriWithType(uriInfo, domain, type), HttpMethod.POST, null, inputStream, contentType);
    }

    @PUT
    @Path(value="/{type}")
    public Response putCollection(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, InputStream inputStream, @HeaderParam(value="Content-Type") MediaType contentType, @Rest QueryParameters queryParameters) {
        return this.resourcesService.collectionOperation(domain, type, request, uriInfo, this.getTokenInfo(authorizationInfo), this.getBaseUriWithType(uriInfo, domain, type), HttpMethod.PUT, queryParameters, inputStream, contentType);
    }

    @DELETE
    @Path(value="/{type}")
    public Response deleteCollection(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @Rest QueryParameters queryParameters) {
        return this.resourcesService.collectionOperation(domain, type, request, uriInfo, this.getTokenInfo(authorizationInfo), this.getBaseUriWithType(uriInfo, domain, type), HttpMethod.DELETE, queryParameters, null, null);
    }

    @GET
    @Path(value="/{type}/{id}")
    public Response getResource(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @Rest QueryParameters queryParameters) {
        URI typeUri = this.getBaseUriWithType(uriInfo, domain, type);
        this.updateRequestWithLinksTypeAndUri(request, typeUri, type);
        return this.resourcesService.resourceOperation(domain, type, id, request, queryParameters, uriInfo, this.getTokenInfo(authorizationInfo), typeUri, HttpMethod.GET, null, null, null);
    }

    @PUT
    @Path(value="/{type}/{id}")
    public Response putResource(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, InputStream inputStream, @HeaderParam(value="Content-Type") MediaType contentType, @HeaderParam(value="Content-Length") Long contentLength, @Rest QueryParameters queryParameters) {
        return this.resourcesService.resourceOperation(domain, type, id, request, queryParameters, uriInfo, this.getTokenInfo(authorizationInfo), this.getBaseUriWithType(uriInfo, domain, type), HttpMethod.PUT, inputStream, contentType, contentLength);
    }

    @DELETE
    @Path(value="/{type}/{id}")
    public Response deleteResource(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @Rest QueryParameters queryParameters) {
        return this.resourcesService.resourceOperation(domain, type, id, request, queryParameters, uriInfo, this.getTokenInfo(authorizationInfo), this.getBaseUriWithType(uriInfo, domain, type), HttpMethod.DELETE, null, null, null);
    }

    @GET
    @Path(value="/{type}/{id}/{rel}")
    public Response getRelation(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @PathParam(value="rel") String rel, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @Rest QueryParameters queryParameters, @MatrixParam(value="r") String resource) {
        URI typeUri = this.getBaseUri(uriInfo, domain);
        this.updateRequestWithLinksTypeAndUri(request, typeUri, type);
        return this.resourcesService.relationOperation(domain, type, id, rel, request, uriInfo, this.getTokenInfo(authorizationInfo), HttpMethod.GET, queryParameters, resource, null, null);
    }

    @POST
    @Path(value="/{type}/{id}/{rel}")
    public Response postRelation(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @PathParam(value="rel") String rel, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, InputStream inputStream, @HeaderParam(value="Content-Type") MediaType contentType) {
        return this.resourcesService.relationOperation(domain, type, id, rel, request, uriInfo, this.getTokenInfo(authorizationInfo), HttpMethod.POST, null, null, inputStream, contentType);
    }

    @PUT
    @Path(value="/{type}/{id}/{rel}")
    public Response putRelation(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @PathParam(value="rel") String rel, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @MatrixParam(value="r") String resource, InputStream inputStream, @HeaderParam(value="Content-Type") MediaType contentType) {
        return this.resourcesService.relationOperation(domain, type, id, rel, request, uriInfo, this.getTokenInfo(authorizationInfo), HttpMethod.PUT, null, resource, inputStream, contentType);
    }

    @DELETE
    @Path(value="/{type}/{id}/{rel}")
    public Response deleteRelation(@PathParam(value="domain") String domain, @PathParam(value="type") String type, @PathParam(value="id") ResourceId id, @PathParam(value="rel") String rel, @Context Request request, @Context UriInfo uriInfo, @Auth AuthorizationInfo authorizationInfo, @MatrixParam(value="r") String resource, @Rest QueryParameters queryParameters) {
        return this.resourcesService.relationOperation(domain, type, id, rel, request, uriInfo, this.getTokenInfo(authorizationInfo), HttpMethod.DELETE, queryParameters, resource, null, null);
    }

    private void updateRequestWithLinksTypeAndUri(Request request, URI typeUri, String type) {
        try {
            ContainerRequest containerRequest = (ContainerRequest)request;
            containerRequest.setProperty("type", (Object)type);
            containerRequest.setProperty("uri", (Object)typeUri);
        }
        catch (ClassCastException e) {
            LOG.error("Couldn't cast Request to ContainerRequest", (Throwable)e);
        }
    }

    private URI getBaseUri(UriInfo uriInfo, String domain) {
        return uriInfo.getBaseUriBuilder().path(this.getClass()).build(new Object[]{domain});
    }

    private URI getBaseUriWithType(UriInfo uriInfo, String domain, String type) {
        return uriInfo.getBaseUriBuilder().path(this.getClass()).path(type).build(new Object[]{domain});
    }

    private TokenInfo getTokenInfo(AuthorizationInfo authorizationInfo) {
        return authorizationInfo != null ? authorizationInfo.getTokenReader().getInfo() : null;
    }
}

