/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.href;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.corbel.resources.href.LinkGenerator;
import io.corbel.resources.href.LinksBuilder;
import java.net.URI;
import java.util.Optional;
import java.util.Set;

public class DefaultLinkGenerator
implements LinkGenerator {
    private static final String ID = "id";

    @Override
    public JsonObject addResourceLinks(JsonObject resource, URI typeUri, Optional<Set<String>> relations) {
        LinksBuilder builder = new LinksBuilder();
        Optional<LinksBuilder.ResourceLinksBuilder> resourceLinksBuilder = this.addSelfLink(resource, builder.typeUri(typeUri));
        if (resourceLinksBuilder.isPresent() && relations.isPresent()) {
            this.addRelationsLink(relations.get(), resourceLinksBuilder.get());
        }
        builder.appendLinks(resource);
        return resource;
    }

    private Optional<LinksBuilder.ResourceLinksBuilder> addSelfLink(JsonObject resource, LinksBuilder.GroundLinksBuilder builder) {
        JsonElement idElement;
        LinksBuilder.ResourceLinksBuilder resourceLinksBuilder = null;
        if (resource.has(ID) && (idElement = resource.get(ID)).isJsonPrimitive()) {
            resourceLinksBuilder = builder.id(idElement.getAsString());
            resourceLinksBuilder.buildSelfLink();
        }
        return Optional.ofNullable(resourceLinksBuilder);
    }

    private void addRelationsLink(Set<String> resourceRelations, LinksBuilder.ResourceLinksBuilder builder) {
        for (String relation : resourceRelations) {
            builder.buildRelationLink(relation);
        }
    }
}

