/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.href;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.corbel.resources.href.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;

public class LinksBuilder {
    public static final String SELF = "self";
    private final List<Link> links = new ArrayList<Link>();

    public GroundLinksBuilder typeUri(URI typeUri) {
        return new GroundLinksBuilder(typeUri);
    }

    public void appendLinks(JsonObject object) {
        if (this.links.isEmpty()) {
            return;
        }
        JsonArray objectLinks = new JsonArray();
        for (Link link : this.links) {
            JsonElement jsonObjectLink = new Gson().toJsonTree((Object)link);
            objectLinks.add(jsonObjectLink);
        }
        object.add("links", (JsonElement)objectLinks);
    }

    public class ResourceLinksBuilder {
        private final URI resourceUri;

        public ResourceLinksBuilder(URI typeUri, String id) {
            this.resourceUri = UriBuilder.fromUri((URI)typeUri).path("/{id}").buildFromEncoded((Object[])new String[]{id});
        }

        public LinksBuilder buildSelfLink() {
            LinksBuilder.this.links.add(new Link(LinksBuilder.SELF, this.resourceUri.toASCIIString()));
            return LinksBuilder.this;
        }

        public LinksBuilder buildRelationLink(String relationName) {
            LinksBuilder.this.links.add(new Link(relationName, UriBuilder.fromUri((URI)this.resourceUri).path("/{relation}").buildFromEncoded(new Object[]{relationName}).toASCIIString()));
            return LinksBuilder.this;
        }

        public URI getResourceUri() {
            return this.resourceUri;
        }
    }

    public class GroundLinksBuilder {
        private final URI typeUri;

        private GroundLinksBuilder(URI typeUri) {
            this.typeUri = typeUri;
        }

        public ResourceLinksBuilder id(String id) {
            return new ResourceLinksBuilder(this.typeUri, id);
        }
    }
}

