/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.service;

import io.corbel.resources.model.RelationSchema;
import io.corbel.resources.rem.plugin.RelationRegistry;
import io.corbel.resources.repository.RelationSchemaRepository;
import io.corbel.resources.service.RelationSchemaService;
import java.io.Serializable;
import java.util.Set;

public class DefaultRelationSchemaService
implements RelationSchemaService {
    private final RelationSchemaRepository repository;
    private final RelationRegistry relationRegistry;

    public DefaultRelationSchemaService(RelationSchemaRepository repository, RelationRegistry relationRegistry) {
        this.repository = repository;
        this.relationRegistry = relationRegistry;
    }

    @Override
    public Set<String> getTypeRelations(String type) {
        Set typeRelations = this.relationRegistry.getTypeRelations(type);
        RelationSchema relationSchema = (RelationSchema)this.repository.findOne((Serializable)((Object)type));
        if (relationSchema != null) {
            Set<String> keySet = relationSchema.getRelations().keySet();
            typeRelations.addAll(keySet);
        }
        return typeRelations;
    }

    @Override
    public Set<String> getRelationFields(String type, String relation) {
        Set<String> relations;
        Set relationFields = this.relationRegistry.getRelationFields(type, relation);
        RelationSchema relationSchema = (RelationSchema)this.repository.findOne((Serializable)((Object)type));
        if (relationSchema != null && (relations = relationSchema.getRelations().get(relation)) != null) {
            relationFields.addAll(relations);
        }
        return relationFields;
    }
}

