/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.service;

import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.resources.rem.Rem;
import io.corbel.resources.rem.RemRegistry;
import io.corbel.resources.rem.model.RemDescription;
import io.corbel.resources.rem.request.CollectionParameters;
import io.corbel.resources.rem.request.RelationParameters;
import io.corbel.resources.rem.request.RequestParameters;
import io.corbel.resources.rem.request.ResourceId;
import io.corbel.resources.rem.request.ResourceParameters;
import io.corbel.resources.rem.service.RemService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class DefaultRemService
implements RemService {
    private final Map<String, List<Rem>> remsExcludedForUri = new HashMap<String, List<Rem>>();
    private final RemRegistry registry;

    public DefaultRemService(RemRegistry registry) {
        this.registry = registry;
    }

    public Rem getRem(String name) {
        return this.registry.getRem(name);
    }

    public Rem getRem(String type, List<MediaType> acceptedMediaTypes, HttpMethod method) {
        return this.getRemFromRegistry(type, acceptedMediaTypes, method, null);
    }

    public Rem getRem(String type, List<MediaType> acceptedMediaTypes, HttpMethod method, List<Rem> remsExcluded) {
        ArrayList<Rem> remsToExclude = new ArrayList<Rem>();
        if (remsExcluded != null) {
            remsToExclude.addAll(remsExcluded);
        }
        if (this.remsExcludedForUri.containsKey(type)) {
            remsToExclude.addAll((Collection<Rem>)this.remsExcludedForUri.get(type));
        }
        return this.getRemFromRegistry(type, acceptedMediaTypes, method, remsToExclude);
    }

    private Rem getRemFromRegistry(String type, List<MediaType> acceptedMediaTypes, HttpMethod method, List<Rem> remsExcluded) {
        Rem rem = this.registry.getRem(type, acceptedMediaTypes, method, remsExcluded);
        if (rem == null) {
            throw new WebApplicationException(ErrorResponseFactory.getInstance().notFound());
        }
        return rem;
    }

    public void registerExcludedRems(String uri, List<Rem> excludedRems) {
        if (excludedRems != null) {
            if (this.remsExcludedForUri.containsKey(uri)) {
                this.remsExcludedForUri.get(uri).addAll(excludedRems);
            } else {
                this.remsExcludedForUri.put(uri, new ArrayList<Rem>(excludedRems));
            }
        }
    }

    public void registerRem(Rem rem, String uriPattern, HttpMethod httpMethod) {
        this.registry.registerRem(rem, uriPattern, new HttpMethod[]{httpMethod});
    }

    public void unregisterRem(Class<?> remClass, String uriPattern) {
        this.registry.unregisterRem(remClass, uriPattern, MediaType.ALL);
    }

    public Response collection(Rem rem, String type, RequestParameters<CollectionParameters> parameters, URI uri, Optional entity, List<Rem> remsExcluded) {
        return rem.collection(type, parameters, uri, entity, Optional.ofNullable(remsExcluded));
    }

    public Response resource(Rem rem, String type, ResourceId id, RequestParameters<ResourceParameters> parameters, Optional entity, List<Rem> remsExcluded) {
        return rem.resource(type, id, parameters, entity, Optional.ofNullable(remsExcluded));
    }

    public Response relation(Rem rem, String type, ResourceId id, String rel, RequestParameters<RelationParameters> parameters, Optional entity, List<Rem> remsExcluded) {
        return rem.relation(type, id, rel, parameters, entity, Optional.ofNullable(remsExcluded));
    }

    public List<RemDescription> getRegisteredRemDescriptions() {
        return this.registry.getRegistryDescription();
    }
}

