/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.resources.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.collect.Lists;
import io.corbel.event.ResourceEvent;
import io.corbel.eventbus.Event;
import io.corbel.eventbus.service.EventBus;
import io.corbel.lib.queries.jaxrs.QueryParameters;
import io.corbel.lib.queries.parser.QueryParametersParser;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.ws.api.error.ApiRequestException;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.rem.internal.RemEntityTypeResolver;
import io.corbel.resources.rem.Rem;
import io.corbel.resources.rem.request.CollectionParameters;
import io.corbel.resources.rem.request.CollectionParametersImpl;
import io.corbel.resources.rem.request.RelationParameters;
import io.corbel.resources.rem.request.RelationParametersImpl;
import io.corbel.resources.rem.request.RequestParameters;
import io.corbel.resources.rem.request.RequestParametersImpl;
import io.corbel.resources.rem.request.ResourceId;
import io.corbel.resources.rem.request.ResourceParameters;
import io.corbel.resources.rem.request.ResourceParametersImpl;
import io.corbel.resources.rem.service.RemService;
import io.corbel.resources.service.ResourcesService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class DefaultResourcesService
implements ResourcesService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourcesService.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final String UNABLE_TO_READ_ERROR = "Unable to read entity from content of media type {}";
    private final RemService remService;
    private final RemEntityTypeResolver remEntityTypeResolver;
    private final int defaultPageSize;
    private final int maxPageSize;
    private final EventBus eventBus;
    private final QueryParametersParser queryParametersParser;
    private Providers providers;

    public DefaultResourcesService(RemService remService, RemEntityTypeResolver remEntityTypeResolver, int defaultPageSize, int maxPageSize, QueryParametersParser queryParametersBuilder, EventBus eventBus) {
        this.remService = remService;
        this.remEntityTypeResolver = remEntityTypeResolver;
        this.defaultPageSize = defaultPageSize;
        this.maxPageSize = maxPageSize;
        this.queryParametersParser = queryParametersBuilder;
        this.eventBus = eventBus;
    }

    @Override
    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    @Override
    public Response collectionOperation(String domain, String type, Request request, UriInfo uriInfo, TokenInfo tokenInfo, URI typeUri, HttpMethod method, QueryParameters queryParameters, InputStream inputStream, javax.ws.rs.core.MediaType contentType) {
        Response result;
        try {
            List<MediaType> acceptedMediaTypes = this.getRequestAcceptedMediaTypes(request);
            Rem rem = this.remService.getRem(type, acceptedMediaTypes, method);
            queryParameters = method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.DELETE) || method.equals((Object)HttpMethod.PUT) ? queryParameters : this.getDefaultQueryParameters();
            RequestParameters<CollectionParameters> parameters = this.collectionParameters(domain, queryParameters, tokenInfo, acceptedMediaTypes, (MultivaluedMap<String, String>)uriInfo.getQueryParameters(), request);
            Optional entity = method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT) ? this.getEntity(Optional.ofNullable(inputStream), rem, contentType) : Optional.empty();
            result = this.remService.collection(rem, type, parameters, typeUri, entity);
        }
        catch (JsonParseException e) {
            return ErrorResponseFactory.getInstance().invalidEntity(e.getOriginalMessage());
        }
        catch (IOException e) {
            LOG.error(UNABLE_TO_READ_ERROR, (Object)contentType, (Object)e);
            return ErrorResponseFactory.getInstance().serverError((Throwable)e);
        }
        catch (ApiRequestException e) {
            return ErrorResponseFactory.getInstance().badRequest(e);
        }
        if (method == HttpMethod.POST && tokenInfo != null && result.getMetadata().containsKey((Object)"Location") && (result.getStatus() == 201 || result.getStatus() == 200)) {
            this.eventBus.dispatch((Event)ResourceEvent.createResourceEvent((String)type, (String)result.getMetadata().getFirst((Object)"Location").toString(), (String)tokenInfo.getDomainId(), (String)tokenInfo.getUserId()));
        }
        return result;
    }

    @Override
    public Response resourceOperation(String domain, String type, ResourceId id, Request request, QueryParameters queryParameters, UriInfo uriInfo, TokenInfo tokenInfo, URI typeUri, HttpMethod method, InputStream inputStream, javax.ws.rs.core.MediaType contentType, Long contentLength) {
        Response result;
        if (id.isWildcard()) {
            return this.collectionOperation(domain, type, request, uriInfo, tokenInfo, typeUri, method, queryParameters, inputStream, contentType);
        }
        try {
            List<MediaType> acceptedMediaTypes = this.getRequestAcceptedMediaTypes(request);
            Rem rem = this.remService.getRem(type, acceptedMediaTypes, method);
            RequestParameters<ResourceParameters> resourceParameters = this.resourceParameters(domain, queryParameters, tokenInfo, acceptedMediaTypes, contentLength, (MultivaluedMap<String, String>)uriInfo.getQueryParameters(), request);
            Optional entity = method == HttpMethod.PUT ? this.getEntity(Optional.ofNullable(inputStream), rem, contentType) : Optional.empty();
            result = this.remService.resource(rem, type, id, resourceParameters, entity);
        }
        catch (JsonParseException e) {
            return ErrorResponseFactory.getInstance().invalidEntity(e.getOriginalMessage());
        }
        catch (IOException e) {
            LOG.error(UNABLE_TO_READ_ERROR, (Object)contentType, (Object)e);
            result = ErrorResponseFactory.getInstance().serverError((Throwable)e);
        }
        catch (ApiRequestException e) {
            result = ErrorResponseFactory.getInstance().badRequest(e);
        }
        this.sendEvent(method, tokenInfo, result, 204, type, id.getId(), method == HttpMethod.PUT);
        return result;
    }

    @Override
    public Response relationOperation(String domain, String type, ResourceId id, String rel, Request request, UriInfo uriInfo, TokenInfo tokenInfo, HttpMethod method, QueryParameters queryParameters, String resource, InputStream inputStream, javax.ws.rs.core.MediaType contentType) {
        String relationId;
        Response result;
        try {
            List<MediaType> acceptedMediaTypes = this.getRequestAcceptedMediaTypes(request);
            Rem rem = this.remService.getRem(type + "/" + id.getId() + "/" + rel, acceptedMediaTypes, method);
            queryParameters = Optional.ofNullable(queryParameters).orElse(this.getDefaultQueryParameters());
            RequestParameters<RelationParameters> parameters = this.relationParameters(domain, queryParameters, Optional.ofNullable(resource), tokenInfo, acceptedMediaTypes, (MultivaluedMap<String, String>)uriInfo.getQueryParameters(), request);
            Optional<?> entity = this.getEntity(Optional.ofNullable(inputStream), rem, contentType);
            result = this.remService.relation(rem, type, id, rel, parameters, entity);
            relationId = parameters.getOptionalApiParameters().flatMap(RelationParameters::getPredicateResource).orElse(null);
        }
        catch (JsonParseException e) {
            return ErrorResponseFactory.getInstance().invalidEntity(e.getOriginalMessage());
        }
        catch (IOException e) {
            LOG.error(UNABLE_TO_READ_ERROR, (Object)contentType, (Object)e);
            return ErrorResponseFactory.getInstance().serverError((Throwable)e);
        }
        catch (ApiRequestException e) {
            return ErrorResponseFactory.getInstance().badRequest(e);
        }
        this.sendEvent(method, tokenInfo, result, 201, type + "/" + id.getId() + "/" + rel, relationId, method != HttpMethod.DELETE);
        return result;
    }

    private void sendEvent(HttpMethod method, TokenInfo tokenInfo, Response result, int expectedStatus, String type, String id, boolean updateCondition) {
        if (method != HttpMethod.GET && tokenInfo != null && (result.getStatus() == expectedStatus || result.getStatus() == 200)) {
            ResourceEvent event = updateCondition ? ResourceEvent.updateResourceEvent((String)type, (String)id, (String)tokenInfo.getDomainId(), (String)tokenInfo.getUserId()) : ResourceEvent.deleteResourceEvent((String)type, (String)id, (String)tokenInfo.getDomainId(), (String)tokenInfo.getUserId());
            this.eventBus.dispatch((Event)event);
        }
    }

    private RequestParameters<CollectionParameters> collectionParameters(String domain, QueryParameters queryParameters, TokenInfo tokenInfo, List<MediaType> acceptedMediaTypes, MultivaluedMap<String, String> params, Request request) {
        return new RequestParametersImpl((Object)new CollectionParametersImpl(queryParameters), tokenInfo, domain, acceptedMediaTypes, null, params, this.getHeadersFromRequest(request));
    }

    private RequestParameters<ResourceParameters> resourceParameters(String domain, QueryParameters queryParameters, TokenInfo tokenInfo, List<MediaType> acceptedMediaTypes, Long contentLength, MultivaluedMap<String, String> params, Request request) {
        return new RequestParametersImpl((Object)new ResourceParametersImpl(queryParameters), tokenInfo, domain, acceptedMediaTypes, contentLength, params, this.getHeadersFromRequest(request));
    }

    private RequestParameters<RelationParameters> relationParameters(String domain, QueryParameters queryParameters, Optional<String> predicateResourceUri, TokenInfo tokenInfo, List<MediaType> acceptedMediaTypes, MultivaluedMap<String, String> params, Request request) {
        return new RequestParametersImpl((Object)new RelationParametersImpl(queryParameters, predicateResourceUri), tokenInfo, domain, acceptedMediaTypes, null, params, this.getHeadersFromRequest(request));
    }

    private QueryParameters getDefaultQueryParameters() {
        return this.queryParametersParser.createQueryParameters(0, this.defaultPageSize, this.maxPageSize, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private List<MediaType> getRequestAcceptedMediaTypes(Request request) {
        ContainerRequest containerRequest = (ContainerRequest)request;
        return Lists.transform((List)containerRequest.getAcceptableMediaTypes(), input -> new MediaType(input.getType(), input.getSubtype(), input.getParameters()));
    }

    private MultivaluedMap<String, String> getHeadersFromRequest(Request request) {
        MultivaluedMap headers;
        if (request instanceof ContainerRequest) {
            headers = ((ContainerRequest)request).getRequestHeaders();
        } else {
            LOG.warn("Request is not instance of ContainerRequest");
            headers = new MultivaluedHashMap();
        }
        return headers;
    }

    private Optional<?> getEntity(Optional<InputStream> entityStream, Rem<?> rem, javax.ws.rs.core.MediaType mediaType) throws WebApplicationException, IOException {
        if (entityStream.isPresent()) {
            Class<?> type = this.remEntityTypeResolver.getEntityType(rem);
            MessageBodyReader reader = this.providers.getMessageBodyReader(type, type, EMPTY_ANNOTATIONS, mediaType);
            if (reader != null) {
                return Optional.ofNullable(reader.readFrom(type, type, EMPTY_ANNOTATIONS, mediaType, null, entityStream.get()));
            }
            LOG.warn("Did not find a provider for type {} and mediaType {}", type, (Object)mediaType);
        }
        return Optional.empty();
    }
}

