/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.mongo.builder;

import io.corbel.lib.queries.builder.QueryBuilder;
import io.corbel.lib.queries.mongo.builder.CriteriaBuilder;
import io.corbel.lib.queries.request.Pagination;
import io.corbel.lib.queries.request.ResourceQuery;
import io.corbel.lib.queries.request.Sort;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoQueryBuilder
implements QueryBuilder {
    protected final Query query = new Query();

    public QueryBuilder query(ResourceQuery resourceQuery) {
        if (resourceQuery != null) {
            this.query.addCriteria((CriteriaDefinition)CriteriaBuilder.buildFromResourceQuery(resourceQuery));
        }
        return this;
    }

    public QueryBuilder query(List<ResourceQuery> resourceQueries) {
        if (resourceQueries != null && !resourceQueries.isEmpty()) {
            this.query.addCriteria((CriteriaDefinition)CriteriaBuilder.buildFromResourceQueries(resourceQueries));
        }
        return this;
    }

    public QueryBuilder pagination(Pagination pagination) {
        if (pagination != null) {
            this.query.with((Pageable)new PageRequest(pagination.getPage(), pagination.getPageSize()));
        }
        return this;
    }

    public QueryBuilder sort(Sort sort) {
        if (sort != null) {
            this.query.with(new org.springframework.data.domain.Sort(Sort.Direction.fromString((String)sort.getDirection().name()), new String[]{sort.getField()}));
        }
        return this;
    }

    public Query build() {
        return this.query;
    }
}

