/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.mongo.repository;

import io.corbel.lib.mongo.repository.impl.ExtendedRepository;
import io.corbel.lib.queries.mongo.builder.MongoQueryBuilder;
import io.corbel.lib.queries.mongo.repository.GenericFindRepository;
import io.corbel.lib.queries.request.Pagination;
import io.corbel.lib.queries.request.ResourceQuery;
import io.corbel.lib.queries.request.Sort;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;

public class FindExtendedRepository<E, ID extends Serializable>
extends ExtendedRepository<E, ID>
implements GenericFindRepository<E, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<E, ID> metadata;

    public FindExtendedRepository(MongoEntityInformation<E, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.mongoOperations = mongoOperations;
        this.metadata = metadata;
    }

    @Override
    public List<E> find(ResourceQuery resourceQuery, Pagination pagination, Sort sort) {
        Query query = new MongoQueryBuilder().query(resourceQuery).pagination(pagination).sort(sort).build();
        return this.mongoOperations.find(query, this.metadata.getJavaType(), this.metadata.getCollectionName());
    }

    @Override
    public List<E> find(List<ResourceQuery> resourceQueries, Pagination pagination, Sort sort) {
        Query query = new MongoQueryBuilder().query(resourceQueries).pagination(pagination).sort(sort).build();
        return this.mongoOperations.find(query, this.metadata.getJavaType(), this.metadata.getCollectionName());
    }

    @Override
    public long count(ResourceQuery resourceQuery) {
        Query query = new MongoQueryBuilder().query(resourceQuery).build();
        return this.mongoOperations.count(query, this.metadata.getCollectionName());
    }
}

