/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.event;

import io.corbel.eventbus.EventWithSpecificDomain;

public class ResourceEvent
extends EventWithSpecificDomain {
    private String type;
    private String resourceId;
    private Action action;
    private String userId;

    private ResourceEvent() {
    }

    private ResourceEvent(String type, String resourceId, Action action, String domainId, String userId) {
        super(domainId);
        this.type = type;
        this.resourceId = resourceId;
        this.action = action;
        this.userId = userId;
    }

    private ResourceEvent(String type, String resourceId, String domain, Action action, String userId) {
        super(domain);
        this.type = type;
        this.resourceId = resourceId;
        this.action = action;
        this.userId = userId;
    }

    public static ResourceEvent createResourceEvent(String type, String resourceId, String domainId, String userId) {
        return new ResourceEvent(type, resourceId, Action.CREATE, domainId, userId);
    }

    public static ResourceEvent updateResourceEvent(String type, String resourceId, String domainId, String userId) {
        return new ResourceEvent(type, resourceId, Action.UPDATE, domainId, userId);
    }

    public static ResourceEvent deleteResourceEvent(String type, String resourceId, String domainId, String userId) {
        return new ResourceEvent(type, resourceId, Action.DELETE, domainId, userId);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ResourceEvent other = (ResourceEvent)((Object)obj);
        if (this.action != other.action) {
            return false;
        }
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

    }
}

