/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.token;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.corbel.lib.token.model.TokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class TokenInfo {
    private static final String TYPE = "type";
    private static final String USER_ID = "userId";
    private static final String CLIENT_ID = "clientId";
    private static final String DEVICE_ID = "deviceId";
    private static final String ONE_USE = "isOneUse";
    private static final String STATE = "state";
    private static final String DOMAIN_ID = "domainId";
    private static final String GROUPS = "groups";
    private final JsonObject data;

    public static TokenInfo deserialize(String asAString) {
        Validate.notEmpty((CharSequence)asAString);
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(asAString);
            Validate.isTrue((boolean)json.isJsonObject());
            return new TokenInfo(json.getAsJsonObject());
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private TokenInfo(JsonObject data) {
        this.data = data;
    }

    public TokenType getTokenType() {
        return TokenType.valueOf(this.getAsString(TYPE).toUpperCase());
    }

    public String getUserId() {
        return this.getAsString(USER_ID);
    }

    public String getClientId() {
        return this.getAsString(CLIENT_ID);
    }

    public String getDeviceId() {
        return this.getAsString(DEVICE_ID);
    }

    public String getState() {
        return this.getAsString(STATE);
    }

    public String getDomainId() {
        return this.getAsString(DOMAIN_ID);
    }

    public Collection<String> getGroups() {
        return this.getAsCollection(GROUPS);
    }

    public boolean isOneUseToken() {
        Boolean val = this.getAsBoolean(ONE_USE);
        return val != null ? val : false;
    }

    public String serialize() {
        return this.data.toString();
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenInfo)) {
            return false;
        }
        TokenInfo that = (TokenInfo)obj;
        return Objects.equals(this.data.toString(), that.data.toString());
    }

    private String getAsString(String key) {
        return this.data.has(key) ? this.data.get(key).getAsString() : null;
    }

    private Boolean getAsBoolean(String key) {
        return this.data.has(key) ? Boolean.valueOf(this.data.get(key).getAsBoolean()) : null;
    }

    private List<String> getAsCollection(String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.data.has(key)) {
            for (JsonElement value : this.data.get(key).getAsJsonArray()) {
                values.add(value.getAsString());
            }
        }
        return values;
    }

    public static class Builder {
        private final JsonObject data = new JsonObject();

        private Builder() {
        }

        public Builder setType(TokenType type) {
            this.data.add(TokenInfo.TYPE, (JsonElement)new JsonPrimitive(type.name()));
            return this;
        }

        public Builder setUserId(String userId) {
            this.data.add(TokenInfo.USER_ID, (JsonElement)new JsonPrimitive(userId));
            return this;
        }

        public Builder setClientId(String clientId) {
            this.data.add(TokenInfo.CLIENT_ID, (JsonElement)new JsonPrimitive(clientId));
            return this;
        }

        public Builder setDeviceId(String deviceIdId) {
            this.data.add(TokenInfo.DEVICE_ID, (JsonElement)new JsonPrimitive(deviceIdId));
            return this;
        }

        public Builder setOneUseToken(boolean isOneUse) {
            this.data.add(TokenInfo.ONE_USE, (JsonElement)new JsonPrimitive(Boolean.valueOf(isOneUse)));
            return this;
        }

        public Builder setState(String state) {
            this.data.add(TokenInfo.STATE, (JsonElement)new JsonPrimitive(state));
            return this;
        }

        public Builder setDomainId(String domainId) {
            this.data.add(TokenInfo.DOMAIN_ID, (JsonElement)new JsonPrimitive(domainId));
            return this;
        }

        public Builder setGroups(Collection<String> groups) {
            JsonArray jsonArray = new JsonArray();
            groups.stream().forEach(group -> jsonArray.add((JsonElement)new JsonPrimitive(group)));
            this.data.add(TokenInfo.GROUPS, (JsonElement)jsonArray);
            return this;
        }

        public TokenInfo build() {
            return new TokenInfo(this.data);
        }
    }
}

