/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.token.model;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.data.annotation.Id;

public class OneTimeAccessToken {
    @Id
    private final String id;
    private final Date expireAt;
    private final List<String> tags;

    public OneTimeAccessToken(String id, Date expireAt, List<String> tags) {
        this.id = id;
        this.expireAt = expireAt;
        this.tags = this.isEmptyList(tags) ? null : tags;
    }

    private boolean isEmptyList(List<String> list) {
        return list == null || list.size() == 0;
    }

    public String getId() {
        return this.id;
    }

    public Date getExpireAt() {
        return this.expireAt;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.expireAt);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OneTimeAccessToken)) {
            return false;
        }
        OneTimeAccessToken that = (OneTimeAccessToken)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.expireAt, that.expireAt);
    }
}

