/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.token.provider;

import com.google.common.base.Optional;
import io.corbel.lib.token.exception.TokenVerificationException;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.token.reader.TokenReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.CookieParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SessionProvider.class);
    private static TokenParser tokenParser;

    public SessionProvider(TokenParser tokenParser) {
        SessionProvider.tokenParser = tokenParser;
    }

    public org.glassfish.hk2.utilities.Binder getBinder() {
        return new Binder();
    }

    @Provider
    public static class SessionFactoryProvider
    extends AbstractValueFactoryProvider {
        @Inject
        protected SessionFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
            super(mpep, locator, new Parameter.Source[]{Parameter.Source.COOKIE});
        }

        protected AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
            String parameterName = parameter.getSourceName();
            if (parameterName == null || parameterName.length() == 0) {
                return null;
            }
            if (this.isOptionalSession(parameter.getType())) {
                return new OptionalSessionInjectable(parameterName);
            }
            if (TokenReader.class.isAssignableFrom(parameter.getRawType())) {
                return new SessionInjectable(parameterName);
            }
            return null;
        }

        private boolean isOptionalSession(Type parameterType) {
            ParameterizedType generic;
            if (parameterType instanceof ParameterizedType && (generic = (ParameterizedType)parameterType).getRawType().equals(Optional.class)) {
                return generic.getActualTypeArguments()[0].equals(TokenReader.class);
            }
            return false;
        }

        private class SessionInjectable
        extends AbstractContainerRequestValueFactory<TokenReader> {
            private final String cookieKey;

            public SessionInjectable(String cookieKey) {
                this.cookieKey = cookieKey;
            }

            public TokenReader provide() {
                Cookie cookie = (Cookie)this.getContainerRequest().getCookies().get(this.cookieKey);
                if (cookie != null) {
                    try {
                        return tokenParser.parseAndVerify(cookie.getValue());
                    }
                    catch (TokenVerificationException e) {
                        LOG.warn("Received invalid session cookie {}", (Object)cookie);
                    }
                }
                return null;
            }
        }

        private class OptionalSessionInjectable
        extends AbstractContainerRequestValueFactory<Optional<TokenReader>> {
            private final SessionInjectable sessionInjectable;

            public OptionalSessionInjectable(String cookieKey) {
                this.sessionInjectable = new SessionInjectable(cookieKey);
            }

            public Optional<TokenReader> provide() {
                return Optional.fromNullable((Object)this.sessionInjectable.provide());
            }
        }
    }

    public static final class SessionInjectionResolver
    extends ParamInjectionResolver<CookieParam> {
        public SessionInjectionResolver() {
            super(SessionFactoryProvider.class);
        }
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(SessionFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(SessionInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<CookieParam>>(){}).in(Singleton.class);
        }
    }
}

