/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import org.joda.time.Interval;

public class IntervalDeserializer
extends JodaDeserializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalDeserializer() {
        super(Interval.class);
    }

    public Interval deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        long end;
        long start;
        boolean hasSlash;
        JsonToken t = jsonParser.getCurrentToken();
        if (t != JsonToken.VALUE_STRING) {
            throw deserializationContext.mappingException("expected JSON String, got " + t);
        }
        String v = jsonParser.getText().trim();
        int index = v.indexOf(47, 1);
        boolean bl = hasSlash = index > 0;
        if (!hasSlash) {
            index = v.indexOf(45, 1);
        }
        if (index < 0) {
            throw deserializationContext.weirdStringException(v, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = v.substring(0, index);
        try {
            if (hasSlash) {
                return Interval.parse((String)v);
            }
            start = Long.valueOf(str);
            str = v.substring(index + 1);
            end = Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw JsonMappingException.from((JsonParser)jsonParser, (String)("Failed to parse number from '" + str + "' (full source String '" + v + "') to construct " + this.handledType().getName()));
        }
        return new Interval(start, end);
    }
}

