/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.api.error;

import io.corbel.lib.ws.api.error.ApiRequestException;
import io.corbel.lib.ws.api.error.ErrorMessage;
import io.corbel.lib.ws.model.Error;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorResponseFactory.class);
    private static final int METHOD_NOT_ALLOWED_STATUS = 405;
    private static final int INVALID_ENTITY = 422;
    private static final int RESOURCE_LOCKED = 423;
    private static final int BAD_GATEWAY = 502;
    private static final Error DEFAULT_FORBIDDEN_ERROR = new Error("forbidden", ErrorMessage.FORBIDDEN.getMessage(new Object[0]));
    private static final Error DEFAULT_UNAUTHORIZED_ERROR = new Error("unauthorized", ErrorMessage.UNAUTHORIZE.getMessage(new Object[0]));
    private static final Error DEFAULT_METHOD_NOT_ALLOWED_ERROR = new Error("method_not_allowed", ErrorMessage.NOT_ALLOWED.getMessage(new Object[0]));
    private static final Error DEFAULT_CONFLICT_ERROR = new Error("conflict", ErrorMessage.CONFLICT.getMessage(new Object[0]));
    private static final Error DEFAULT_NOT_FOUND_ERROR = new Error("not_found", ErrorMessage.NOT_FOUND.getMessage(new Object[0]));
    private static final Error DEFAULT_BAD_REQUEST_ERROR = new Error("bad_request", ErrorMessage.BAD_REQUEST.getMessage(new Object[0]));
    private static final Error GATEWAY_TIMEOUT_ERROR = new Error("gateway_timeout", ErrorMessage.GATEWAY_TIMEOUT.getMessage(new Object[0]));
    private static final Error DEFAULT_BAD_GATEWAY = new Error("bad_gateway", ErrorMessage.BAD_GATEWAY.getMessage(new Object[0]));
    private static ErrorResponseFactory instance;

    public static ErrorResponseFactory getInstance() {
        if (instance == null) {
            LOG.debug("Creating instance of {}", ErrorResponseFactory.class);
            instance = new ErrorResponseFactory();
        }
        return instance;
    }

    protected ErrorResponseFactory() {
    }

    public Response badRequest(ApiRequestException e) {
        return this.badRequest(e.getError());
    }

    public Response serverError(Throwable exception) {
        return this.serverError(new Error("internal_server_error", exception.getMessage()));
    }

    public Response badGateway() {
        return this.badGateway(DEFAULT_BAD_GATEWAY);
    }

    public Response badRequest() {
        return this.badRequest(DEFAULT_BAD_REQUEST_ERROR);
    }

    public Response gatewayTimeout() {
        return this.gatewayTimeout(GATEWAY_TIMEOUT_ERROR);
    }

    public Response notFound() {
        return this.notfound(DEFAULT_NOT_FOUND_ERROR);
    }

    public Response conflict() {
        return this.conflict(DEFAULT_CONFLICT_ERROR);
    }

    public Response conflict(String message) {
        return this.conflict(new Error("conflict", message));
    }

    public Response invalidEntity(String description) {
        return this.invalidEntity(new Error("invalid_entity", ErrorMessage.INVALID_ENTITY.getMessage(description)));
    }

    public Response methodNotAllowed() {
        return this.methodNotAllowed(DEFAULT_METHOD_NOT_ALLOWED_ERROR);
    }

    public Response unauthorized() {
        return this.unauthorized(DEFAULT_UNAUTHORIZED_ERROR);
    }

    public Response unauthorized(String message) {
        return this.unauthorized(new Error("unauthorized", message));
    }

    public Response unauthorized(String error, String errorDescription) {
        return this.unauthorized(new Error(error, errorDescription));
    }

    public Response preconditionFailed(String description) {
        return this.jsonResponse(new Error("precondition_failed", ErrorMessage.PRECONDITION_FAILED.getMessage(description)), Response.Status.PRECONDITION_FAILED);
    }

    public Response forbidden() {
        return this.forbidden(DEFAULT_FORBIDDEN_ERROR);
    }

    public Response badRequest(Error error) {
        return this.jsonResponse(error, Response.Status.BAD_REQUEST);
    }

    public Response gatewayTimeout(Error error) {
        return this.jsonResponse(error, Response.Status.GATEWAY_TIMEOUT);
    }

    public Response notfound(Error error) {
        return this.jsonResponse(error, Response.Status.NOT_FOUND);
    }

    public Response conflict(Error error) {
        return this.jsonResponse(error, Response.Status.CONFLICT);
    }

    public Response invalidEntity(Error error) {
        return this.jsonResponse(error, 422);
    }

    public Response methodNotAllowed(Error error) {
        return this.jsonResponse(error, 405);
    }

    public Response missingParameter(String parameter) {
        return this.badRequest(new Error("missing_parameter", parameter));
    }

    public Response unauthorized(Error error) {
        return this.jsonResponse(error, Response.Status.UNAUTHORIZED);
    }

    public Response forbidden(Error error) {
        return this.jsonResponse(error, Response.Status.FORBIDDEN);
    }

    public Response resourceLocked(Error error) {
        return this.jsonResponse(error, 423);
    }

    public Response serverError(Error error) {
        return this.jsonResponse(error, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public Response badGateway(Error error) {
        return this.jsonResponse(error, 502);
    }

    private Response jsonResponse(Error error, Response.Status status) {
        return this.jsonResponse(error, status.getStatusCode());
    }

    private Response jsonResponse(Error error, int status) {
        return Response.status((int)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

