/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.api.error;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.corbel.lib.ws.model.Error;
import java.util.Collections;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class JsonValidationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private final int notProcessableResponseStatus = 422;
    private static final String DEFAULT_ERROR = "invalid_entity";
    private final String error;

    public JsonValidationExceptionMapper(String error) {
        this.error = error;
    }

    public JsonValidationExceptionMapper() {
        this(DEFAULT_ERROR);
    }

    public Response toResponse(ConstraintViolationException exception) {
        return Response.status((int)422).type("application/json").entity((Object)new Error(this.error, this.generateDescription(exception.getConstraintViolations()))).build();
    }

    private String generateDescription(Set<ConstraintViolation<?>> errors) {
        StringBuilder builder = new StringBuilder("Unprocessable Entity:");
        for (ConstraintViolation<?> errorMessage : errors) {
            builder.append(" ").append(errorMessage.getMessage()).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public class JacksonAdapter
    implements ExceptionMapper<JsonProcessingException> {
        public Response toResponse(JsonProcessingException exception) {
            return JsonValidationExceptionMapper.this.toResponse(new ConstraintViolationException(exception.getMessage() + "Json error at " + exception.getLocation(), Collections.emptySet()));
        }
    }
}

