/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth;

import com.google.gson.JsonObject;
import io.corbel.lib.token.reader.TokenReader;
import java.util.Collections;
import java.util.Set;

public class AuthorizationInfo {
    private final TokenReader tokenReader;
    private final Set<JsonObject> accessRules;

    public AuthorizationInfo(TokenReader tokenReader, Set<JsonObject> accessRules) {
        this.tokenReader = tokenReader;
        this.accessRules = accessRules;
    }

    public TokenReader getTokenReader() {
        return this.tokenReader;
    }

    public Set<JsonObject> getAccessRules() {
        return Collections.unmodifiableSet(this.accessRules);
    }

    public String getUserId() {
        return this.getTokenReader().getInfo().getUserId();
    }

    public String getDeviceId() {
        return this.getTokenReader().getInfo().getDeviceId();
    }

    public String getClientId() {
        return this.getTokenReader().getInfo().getClientId();
    }

    public String getDomainId() {
        return this.getTokenReader().getInfo().getDomainId();
    }

    public String getToken() {
        return this.getTokenReader().getToken();
    }
}

