/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth;

import com.google.gson.JsonObject;
import io.corbel.event.DomainPublicScopesNotPublishedEvent;
import io.corbel.eventbus.Event;
import io.corbel.eventbus.service.EventBus;
import io.corbel.lib.ws.auth.AuthorizationRulesService;
import io.corbel.lib.ws.auth.PublicAccessService;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultPublicAccessService
implements PublicAccessService {
    public static final String PUBLIC_SCOPES_SUFFIX = "_public_scopes";
    private final AuthorizationRulesService authorizationRulesService;
    private final Integer waitTimeForPublishPublicScopes;
    private final EventBus eventBus;
    private final String audience;

    public DefaultPublicAccessService(AuthorizationRulesService authorizationRulesService, Integer waitTimeForPublishPublicScopes, EventBus eventBus, String audience) {
        this.authorizationRulesService = authorizationRulesService;
        this.waitTimeForPublishPublicScopes = waitTimeForPublishPublicScopes;
        this.eventBus = eventBus;
        this.audience = audience;
    }

    @Override
    public Set<JsonObject> getDomainPublicRules(String domainId) {
        if (domainId != null) {
            String token = domainId + PUBLIC_SCOPES_SUFFIX;
            if (!this.authorizationRulesService.existsRulesForToken(token, this.audience)) {
                this.eventBus.dispatch((Event)new DomainPublicScopesNotPublishedEvent(domainId));
                this.waitPublicScopesArePublished();
            }
            return this.authorizationRulesService.getAuthorizationRules(token, this.audience);
        }
        return Collections.EMPTY_SET;
    }

    private void waitPublicScopesArePublished() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.waitTimeForPublishPublicScopes.intValue());
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

