/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth.ioc;

import io.corbel.lib.ws.auth.AuthorizationInfo;
import io.corbel.lib.ws.auth.AuthorizationRequestFilter;
import io.corbel.lib.ws.auth.CookieOAuthFactory;
import io.corbel.lib.ws.auth.ioc.AuthorizationCommonIoc;
import io.corbel.lib.ws.auth.ioc.condition.PublicAccessDisabledCondition;
import io.dropwizard.auth.oauth.OAuthFactory;
import javax.ws.rs.container.ContainerRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AuthorizationCommonIoc.class})
@Conditional(value={PublicAccessDisabledCondition.class})
public class AuthorizationFilterIoc {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationFilterIoc.class);

    @Bean
    public ContainerRequestFilter getAuthorizationRequestFilter(OAuthFactory<AuthorizationInfo> oauthProvider, CookieOAuthFactory<AuthorizationInfo> cookieOauthProvider, @Value(value="${auth.enabled}") boolean authEnabled, @Value(value="${auth.unAuthenticatedPath}") String unAuthenticatedPath, @Value(value="${auth.checkDomain.enabled:false}") boolean checkDomain, @Value(value="${filter.allowRequestWithoutDomainInUri.endpoints:}") String endpoints) {
        if (authEnabled) {
            return new AuthorizationRequestFilter(oauthProvider, cookieOauthProvider, unAuthenticatedPath, checkDomain, endpoints);
        }
        LOG.warn("Authorization validation is disabled. The system runs in INSECURE mode");
        return this.emptyFilter();
    }

    private ContainerRequestFilter emptyFilter() {
        return request -> {};
    }
}

