/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth.ioc;

import io.corbel.eventbus.ioc.EventBusIoc;
import io.corbel.eventbus.service.EventBus;
import io.corbel.lib.ws.auth.AuthorizationInfo;
import io.corbel.lib.ws.auth.AuthorizationRequestFilter;
import io.corbel.lib.ws.auth.AuthorizationRulesService;
import io.corbel.lib.ws.auth.CookieOAuthFactory;
import io.corbel.lib.ws.auth.DefaultPublicAccessService;
import io.corbel.lib.ws.auth.PublicAccessService;
import io.corbel.lib.ws.auth.ioc.AuthorizationCommonIoc;
import io.corbel.lib.ws.auth.ioc.condition.PublicAccessEnabledCondition;
import io.dropwizard.auth.oauth.OAuthFactory;
import javax.ws.rs.container.ContainerRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AuthorizationCommonIoc.class, EventBusIoc.class})
@Conditional(value={PublicAccessEnabledCondition.class})
public class AuthorizationFilterWithPublicAccessIoc {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationFilterWithPublicAccessIoc.class);

    @Bean
    public PublicAccessService getPublicAccessService(AuthorizationRulesService authorizationRulesService, @Value(value="${auth.waitTimeForPublishPublicScopes:500}") Integer waitTimeForPublishPublicScopes, EventBus eventBus, @Value(value="${auth.audience}") String audience) {
        return new DefaultPublicAccessService(authorizationRulesService, waitTimeForPublishPublicScopes, eventBus, audience);
    }

    @Bean
    public ContainerRequestFilter getAuthorizationRequestFilter(OAuthFactory<AuthorizationInfo> oauthProvider, CookieOAuthFactory<AuthorizationInfo> cookieOauthProvider, PublicAccessService publicAccessService, @Value(value="${auth.enabled}") boolean authEnabled, @Value(value="${auth.unAuthenticatedPath}") String unAuthenticatedPath, @Value(value="${auth.checkDomain.enabled:false}") boolean checkDomain, @Value(value="${filter.allowRequestWithoutDomainInUri.endpoints:}") String endpoints) {
        if (authEnabled) {
            return new AuthorizationRequestFilter(oauthProvider, cookieOauthProvider, publicAccessService, unAuthenticatedPath, checkDomain, endpoints);
        }
        LOG.warn("Authorization validation is disabled. The system runs in INSECURE mode");
        return this.emptyFilter();
    }

    private ContainerRequestFilter emptyFilter() {
        return request -> {};
    }
}

