/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.cli;

import io.corbel.lib.ws.cli.CommandLineI;
import io.corbel.lib.ws.cli.CommandLineNotImplemented;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class CliCommand
extends Command {
    private Optional<CommandLineI> commandLine = Optional.empty();

    public CliCommand(String name, String description) {
        super(name, description);
    }

    public void configure(Subparser subparser) {
        subparser.addArgument(new String[]{"files"}).type(String.class).action((ArgumentAction)Arguments.append()).nargs("*").help("Groovy scripts to run instead a command line shell.");
    }

    public void run(Bootstrap<?> bootstrap, Namespace namespace) throws Exception {
        System.setProperty("mode", "console");
        List commandLineFiles = Optional.ofNullable(namespace.get("files")).map(o -> (List)o).filter(filesObject -> !filesObject.isEmpty()).map(filesObject -> (List)filesObject.get(0)).orElse(new ArrayList());
        this.commandLine.orElseThrow(CommandLineNotImplemented::new).run(commandLineFiles);
    }

    public void setCommandLine(CommandLineI commandLine) {
        this.commandLine = Optional.ofNullable(commandLine);
    }
}

