/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.cli;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.joran.spi.JoranException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.corbel.lib.ws.SpringJerseyProvider;
import io.corbel.lib.ws.api.error.GenericExceptionMapper;
import io.corbel.lib.ws.api.error.JsonValidationExceptionMapper;
import io.corbel.lib.ws.api.error.NotFoundExceptionMapper;
import io.corbel.lib.ws.api.error.URISyntaxExceptionMapper;
import io.corbel.lib.ws.cli.CliCommand;
import io.corbel.lib.ws.cli.CommandLineI;
import io.corbel.lib.ws.filter.ChunkedAwaredShallowEtagHeaderFilter;
import io.corbel.lib.ws.filter.OptionalContainerRequestFilter;
import io.corbel.lib.ws.filter.OptionalContainerResponseFilter;
import io.corbel.lib.ws.gson.GsonMessageReaderWriterProvider;
import io.corbel.lib.ws.json.serialization.EmptyEntitiesAllowedJacksonMessageBodyProvider;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.Command;
import io.dropwizard.logging.LoggingFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Generics;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.filter.HttpMethodOverrideFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

public abstract class ServiceRunner<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRunner.class);
    private final ServiceRunnerApplication application = new ServiceRunnerApplication();

    public final void run(String[] arguments) throws Exception {
        LOG.info("Initializing ${conf.namespace} as {}", (Object)this.getName());
        System.setProperty("conf.namespace", this.getName());
        this.application.run(arguments);
        this.resetLogConfig();
    }

    public void setCommandLine(CommandLineI commandLine) {
        this.application.setCommandLine(commandLine);
    }

    protected abstract String getName();

    protected void configureService(Environment environment, ApplicationContext context) {
        environment.jersey().property("jersey.config.server.exception.processResponseErrors", (Object)false);
    }

    protected void bootstrap(Bootstrap<Configuration> bootstrap) {
    }

    protected void configureObjectMapper(ObjectMapper objectMapperFactory) {
        objectMapperFactory.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapperFactory.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    protected ApplicationContext loadSpringContext() {
        Class<T> ioc = this.getIocConfigurationClass();
        LOG.info("Loading spring context from class {}", ioc);
        return new AnnotationConfigApplicationContext(new Class[]{ioc});
    }

    private void configureDefaultProviders(Environment environment) {
        environment.jersey().register((Object)new GsonMessageReaderWriterProvider());
        environment.jersey().register((Object)new EmptyEntitiesAllowedJacksonMessageBodyProvider(environment.getObjectMapper(), environment.getValidator()));
    }

    private void configureDropWizard(Configuration configuration, ApplicationContext applicationContext) {
        configuration.setServerFactory((ServerFactory)applicationContext.getBean(ServerFactory.class));
        configuration.setLoggingFactory((LoggingFactory)applicationContext.getBean(LoggingFactory.class));
    }

    private void configureFiltersAndInterceptors(Environment environment, ApplicationContext applicationContext) {
        Boolean httpMethodOverrideEnabled;
        environment.jersey().register((Object)new JsonValidationExceptionMapper());
        environment.jersey().register((Object)new JsonValidationExceptionMapper().new JsonValidationExceptionMapper.JacksonAdapter());
        environment.jersey().register(NotFoundExceptionMapper.class);
        environment.jersey().register(URISyntaxExceptionMapper.class);
        environment.jersey().register(GenericExceptionMapper.class);
        environment.jersey().getResourceConfig().registerClasses(new Class[]{EncodingFilter.class, GZipEncoder.class, DeflateEncoder.class});
        Boolean etagEnabled = (Boolean)applicationContext.getEnvironment().getProperty("etag.enabled", Boolean.class);
        if (etagEnabled == null || etagEnabled.equals(true)) {
            if (((Boolean)applicationContext.getEnvironment().getProperty("etag.chunked.enabled", Boolean.class, (Object)false)).booleanValue()) {
                environment.getApplicationContext().addFilter(ChunkedAwaredShallowEtagHeaderFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
            } else {
                environment.getApplicationContext().addFilter(ShallowEtagHeaderFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
            }
        }
        if ((httpMethodOverrideEnabled = (Boolean)applicationContext.getEnvironment().getProperty("filter.httpTunnelingFilter.enabled", Boolean.class, (Object)true)).booleanValue()) {
            environment.jersey().register(HttpMethodOverrideFilter.class);
        }
        List disabledRequestFilters = new ArrayList(applicationContext.getBeansOfType(OptionalContainerRequestFilter.class).values()).stream().filter(filter -> !filter.isEnabled()).collect(Collectors.toList());
        ArrayList requestFilters = new ArrayList(applicationContext.getBeansOfType(ContainerRequestFilter.class).values());
        requestFilters.removeAll(disabledRequestFilters);
        requestFilters.forEach(filter -> environment.jersey().register(filter));
        List disabledResponseFilters = new ArrayList(applicationContext.getBeansOfType(OptionalContainerResponseFilter.class).values()).stream().filter(filter -> !filter.isEnabled()).collect(Collectors.toList());
        ArrayList responseFilters = new ArrayList(applicationContext.getBeansOfType(ContainerResponseFilter.class).values());
        responseFilters.removeAll(disabledResponseFilters);
        responseFilters.forEach(filter -> environment.jersey().register(filter));
        Map providers = applicationContext.getBeansOfType(SpringJerseyProvider.class);
        if (providers != null) {
            for (Map.Entry entry : providers.entrySet()) {
                LOG.info("Registering provider: {}", entry.getKey());
                environment.jersey().register((Object)((SpringJerseyProvider)entry.getValue()).getBinder());
            }
        }
    }

    private Class<T> getIocConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), Object.class);
    }

    private void resetLogConfig() throws JoranException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        ContextInitializer initializer = new ContextInitializer(context);
        initializer.autoConfig();
    }

    class ServiceRunnerApplication
    extends Application<Configuration> {
        private final CliCommand cliCommand = new CliCommand("cli", "Command line shell.");

        ServiceRunnerApplication() {
        }

        public void initialize(Bootstrap<Configuration> bootstrap) {
            ServiceRunner.this.configureObjectMapper(bootstrap.getObjectMapper());
            ServiceRunner.this.bootstrap(bootstrap);
            bootstrap.addCommand((Command)this.cliCommand);
        }

        public void run(Configuration configuration, Environment environment) {
            ServiceRunner.this.configureDefaultProviders(environment);
            ApplicationContext applicationContext = ServiceRunner.this.loadSpringContext();
            ServiceRunner.this.configureDropWizard(configuration, applicationContext);
            ServiceRunner.this.configureFiltersAndInterceptors(environment, applicationContext);
            ServiceRunner.this.configureService(environment, applicationContext);
        }

        public void setCommandLine(CommandLineI commandLine) {
            this.cliCommand.setCommandLine(commandLine);
        }
    }
}

