/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.cors.ioc;

import io.corbel.lib.ws.cors.CorsResponseFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class CorsIoc {
    private static final Logger LOG = LoggerFactory.getLogger(CorsIoc.class);
    @Autowired
    private Environment env;

    @Bean
    public ContainerResponseFilter getCorsResponseFilter() {
        boolean enabled = (Boolean)this.env.getProperty("cors.enabled", Boolean.class, (Object)false);
        String allowedOrigins = this.env.getProperty("cors.allowedOrigins", "");
        int preflightRequestMaxAge = (Integer)this.env.getProperty("cors.preflightRequestMaxAge", Integer.class, (Object)86400);
        if (enabled) {
            if (!allowedOrigins.isEmpty()) {
                if (allowedOrigins.equalsIgnoreCase("any")) {
                    LOG.warn("CORS enabled for ANY origin");
                    return CorsResponseFilter.anyOrigin(preflightRequestMaxAge);
                }
                LOG.info("CORS enabled for the following origins {}", (Object)allowedOrigins);
                return CorsResponseFilter.onlyAllowedOrigins(preflightRequestMaxAge, allowedOrigins.split(","));
            }
            LOG.warn("CORS is enabled but the property cors.allowedOrigins is not defined. Disabling CORS!");
        }
        return CorsResponseFilter.disabled();
    }
}

