/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.digest;

import com.google.common.hash.Hashing;
import io.corbel.lib.ws.digest.DefaultDigester;
import io.corbel.lib.ws.digest.Digester;
import io.corbel.lib.ws.digest.GuavaHashFunctionDigester;
import io.corbel.lib.ws.digest.SignedDigester;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;

public class DigesterFactory {
    private static final String codeFormatUTF8 = "UTF-8";
    private static final String codeFormatUTF16 = "UTF-16";

    public static Digester sha512(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-512");
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha512() {
        return DigesterFactory.sha512(null);
    }

    public static Digester sha384(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-384");
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha384() {
        return DigesterFactory.sha384(null);
    }

    public static Digester sha256(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-256");
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha256() {
        return DigesterFactory.sha256(null);
    }

    public static Digester sha1(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-1");
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha1() {
        return DigesterFactory.sha1(null);
    }

    public static Digester md5(String secret) {
        DefaultDigester digester = new DefaultDigester("MD5");
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester md5() {
        return DigesterFactory.md5(null);
    }

    public static Digester sha512Utf8(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-512", codeFormatUTF8);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha512Utf8() {
        return DigesterFactory.sha512Utf8(null);
    }

    public static Digester sha384Utf8(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-384", codeFormatUTF8);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha384Utf8() {
        return DigesterFactory.sha384Utf8(null);
    }

    public static Digester sha256Utf8(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-256", codeFormatUTF8);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha256Utf8() {
        return DigesterFactory.sha256Utf8(null);
    }

    public static Digester sha1Utf8(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-1", codeFormatUTF8);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha1Utf8() {
        return DigesterFactory.sha1Utf8(null);
    }

    public static Digester sha512Utf16(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-512", codeFormatUTF16);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha512Utf16() {
        return DigesterFactory.sha512Utf16(null);
    }

    public static Digester sha384Utf16(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-384", codeFormatUTF16);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha384Utf16() {
        return DigesterFactory.sha384Utf16(null);
    }

    public static Digester sha256Utf16(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-256", codeFormatUTF16);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha256Utf16() {
        return DigesterFactory.sha256Utf16(null);
    }

    public static Digester sha1Utf16(String secret) {
        DefaultDigester digester = new DefaultDigester("SHA-1", codeFormatUTF16);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester sha1Utf16() {
        return DigesterFactory.sha1Utf16(null);
    }

    public static Digester md5Utf16(String secret) {
        DefaultDigester digester = new DefaultDigester("MD5", codeFormatUTF16);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester md5Utf16() {
        return DigesterFactory.md5Utf16(null);
    }

    public static Digester murmur3_32(String secret) {
        GuavaHashFunctionDigester digester = new GuavaHashFunctionDigester(Hashing.murmur3_32());
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester murmur3_32() {
        return DigesterFactory.murmur3_32(null);
    }

    public static Digester murmur3_128(String secret) {
        GuavaHashFunctionDigester digester = new GuavaHashFunctionDigester(Hashing.murmur3_128());
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public static Digester murmur3_128() {
        return DigesterFactory.murmur3_128(null);
    }

    public Digester md5Utf8(String secret) {
        DefaultDigester digester = new DefaultDigester("MD5", codeFormatUTF8);
        return null != secret ? new SignedDigester(digester, secret) : digester;
    }

    public Digester md5Utf8() {
        return this.md5Utf8(null);
    }

    public static String generateSalt() {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[16];
            sr.nextBytes(salt);
            return new String(Base64.encodeBase64((byte[])salt));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

